/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.Channel;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.ShutdownableService;
import org.apache.camel.StatefulService;
import org.apache.camel.Suspendable;
import org.apache.camel.SuspendableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceHelper.class);

    private ServiceHelper() {
    }

    public static void startService(Object value) throws Exception {
        if (value instanceof Service) {
            ((Service)value).start();
        } else if (value instanceof Iterable) {
            for (Object o : (Iterable)value) {
                ServiceHelper.startService(o);
            }
        }
    }

    public static void startService(Object ... services) throws Exception {
        if (services != null) {
            for (Object o : services) {
                ServiceHelper.startService(o);
            }
        }
    }

    public static void stopService(Object ... services) throws Exception {
        if (services != null) {
            for (Object o : services) {
                ServiceHelper.stopService(o);
            }
        }
    }

    public static void stopService(Object value) throws Exception {
        if (value instanceof Service) {
            ((Service)value).stop();
        } else if (value instanceof Iterable) {
            for (Object o : (Iterable)value) {
                ServiceHelper.stopService(o);
            }
        }
    }

    public static void stopService(Collection<?> services) throws Exception {
        if (services == null) {
            return;
        }
        Exception firstException = null;
        for (Object value : services) {
            try {
                ServiceHelper.stopService(value);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Caught exception stopping service: {}", value, (Object)e);
                }
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public static void stopAndShutdownServices(Object ... services) throws Exception {
        if (services == null) {
            return;
        }
        List<Object> list = Arrays.asList(services);
        ServiceHelper.stopAndShutdownServices(list);
    }

    public static void stopAndShutdownService(Object value) throws Exception {
        ServiceHelper.stopService(value);
        if (value instanceof ShutdownableService) {
            ShutdownableService service = (ShutdownableService)value;
            LOG.trace("Shutting down service {}", value);
            service.shutdown();
        }
    }

    public static void stopAndShutdownServices(Collection<?> services) throws Exception {
        if (services == null) {
            return;
        }
        Exception firstException = null;
        for (Object value : services) {
            try {
                ServiceHelper.stopService(value);
                if (!(value instanceof ShutdownableService)) continue;
                ShutdownableService service = (ShutdownableService)value;
                LOG.trace("Shutting down service: {}", (Object)service);
                service.shutdown();
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Caught exception shutting down service: {}", value, (Object)e);
                }
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public static void resumeServices(Collection<?> services) throws Exception {
        if (services == null) {
            return;
        }
        Exception firstException = null;
        for (Object value : services) {
            if (!(value instanceof Service)) continue;
            Service service = (Service)value;
            try {
                ServiceHelper.resumeService(service);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Caught exception resuming service: {}", (Object)service, (Object)e);
                }
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public static boolean resumeService(Object service) throws Exception {
        if (service instanceof Suspendable && service instanceof SuspendableService) {
            SuspendableService ss = (SuspendableService)service;
            if (ss.isSuspended()) {
                LOG.debug("Resuming service {}", service);
                ss.resume();
                return true;
            }
            return false;
        }
        ServiceHelper.startService(service);
        return true;
    }

    public static void suspendServices(Collection<?> services) throws Exception {
        if (services == null) {
            return;
        }
        Exception firstException = null;
        for (Object value : services) {
            if (!(value instanceof Service)) continue;
            Service service = (Service)value;
            try {
                ServiceHelper.suspendService(service);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Caught exception suspending service: {}", (Object)service, (Object)e);
                }
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public static boolean suspendService(Object service) throws Exception {
        if (service instanceof Suspendable && service instanceof SuspendableService) {
            SuspendableService ss = (SuspendableService)service;
            if (!ss.isSuspended()) {
                LOG.trace("Suspending service {}", service);
                ss.suspend();
                return true;
            }
            return false;
        }
        ServiceHelper.stopService(service);
        return true;
    }

    public static boolean isStopped(Object value) {
        StatefulService service;
        return value instanceof StatefulService && ((service = (StatefulService)value).isStopping() || service.isStopped());
    }

    public static boolean isStarted(Object value) {
        StatefulService service;
        return value instanceof StatefulService && ((service = (StatefulService)value).isStarting() || service.isStarted());
    }

    public static boolean isSuspended(Object value) {
        StatefulService service;
        return value instanceof StatefulService && ((service = (StatefulService)value).isSuspending() || service.isSuspended());
    }

    public static Set<Service> getChildServices(Service service) {
        return ServiceHelper.getChildServices(service, false);
    }

    public static Set<Service> getChildServices(Service service, boolean includeErrorHandler) {
        LinkedHashSet<Service> answer = new LinkedHashSet<Service>();
        ServiceHelper.doGetChildServices(answer, service, includeErrorHandler);
        return answer;
    }

    private static void doGetChildServices(Set<Service> services, Service service, boolean includeErrorHandler) {
        Navigate nav;
        services.add(service);
        if (service instanceof Navigate && (nav = (Navigate)((Object)service)).hasNext()) {
            List children = nav.next();
            for (Object child : children) {
                if (child instanceof Channel) {
                    Processor next;
                    Processor errorHandler;
                    if (includeErrorHandler && (errorHandler = ((Channel)child).getErrorHandler()) instanceof Service) {
                        services.add((Service)((Object)errorHandler));
                    }
                    if ((next = ((Channel)child).getNextProcessor()) instanceof Service) {
                        services.add((Service)((Object)next));
                    }
                }
                if (!(child instanceof Service)) continue;
                ServiceHelper.doGetChildServices(services, (Service)child, includeErrorHandler);
            }
        }
    }
}

