/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.converter.BaseTypeConverterRegistry;
import org.apache.camel.impl.converter.FastAnnotationTypeConverterLoader;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastTypeConverterRegistry
extends BaseTypeConverterRegistry {
    public static final String META_INF_SERVICES = "META-INF/services/org/apache/camel/TypeConverterLoader";
    private static final Logger LOG = LoggerFactory.getLogger(FastTypeConverterRegistry.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public FastTypeConverterRegistry() {
        super(null, null, null);
    }

    public boolean allowNull() {
        return false;
    }

    public boolean isRunAllowed() {
        return true;
    }

    protected void doInit() {
        try {
            this.loadCoreTypeConverters();
            int core = this.typeMappings.size();
            this.log.debug("Initializing FastTypeConverterRegistry - requires converters to be annotated with @Converter(loader = true)");
            this.loadTypeConverters();
            int additional = this.typeMappings.size() - core;
            this.log.info("Type converters loaded (core: {}, classpath: {})", (Object)core, (Object)additional);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this.camelContext.isLoadTypeConverters().booleanValue()) {
            try {
                this.setInjector(this.camelContext.getInjector());
                int fast = this.typeMappings.size();
                FastAnnotationTypeConverterLoader loader = new FastAnnotationTypeConverterLoader(this.camelContext.getPackageScanClassResolver());
                loader.load(this);
                int additional = this.typeMappings.size() - fast;
                if (additional > 0) {
                    this.log.info("Type converters loaded (fast: {}, scanned: {})", (Object)fast, (Object)additional);
                    this.log.warn("Annotation scanning mode loaded {} type converters. Its recommended to migrate to @Converter(loader = true) for fast type converter mode.", (Object)additional);
                }
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    @Override
    public void loadTypeConverters() throws Exception {
        String[] lines;
        for (String line : lines = this.findTypeConverterLoaderClasses()) {
            String name = StringHelper.after((String)line, (String)"class=");
            if (name == null) continue;
            LOG.debug("Resolving TypeConverterLoader: {}", (Object)name);
            Class clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(name);
            Object obj = this.getCamelContext().getInjector().newInstance(clazz);
            if (!(obj instanceof TypeConverterLoader)) continue;
            TypeConverterLoader loader = (TypeConverterLoader)obj;
            LOG.debug("TypeConverterLoader: {} loading converters", (Object)name);
            loader.load((TypeConverterRegistry)this);
        }
    }

    protected String[] findTypeConverterLoaderClasses() throws IOException {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        this.findLoaders(classes, ((Object)((Object)this)).getClass().getClassLoader());
        return classes.toArray(new String[classes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findLoaders(Set<String> packages, ClassLoader classLoader) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(META_INF_SERVICES);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            LOG.debug("Loading file {} to retrieve list of type converters, from url: {}", (Object)META_INF_SERVICES, (Object)url);
            BufferedReader reader = IOHelper.buffered((Reader)new InputStreamReader(url.openStream(), UTF8));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                    this.tokenize(packages, line);
                }
            }
            finally {
                IOHelper.close((Closeable)reader, null, (Logger)LOG);
            }
        }
    }

    private void tokenize(Set<String> packages, String line) {
        StringTokenizer iter = new StringTokenizer(line, ",");
        while (iter.hasMoreTokens()) {
            String name = iter.nextToken().trim();
            if (name.length() <= 0) continue;
            packages.add(name);
        }
    }
}

