/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.filter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionDirector;
import org.apache.dubbo.common.extension.support.MultiInstanceActivateComparator;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;
import org.apache.dubbo.rpc.cluster.filter.FilterChainBuilder;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

@Activate
public class DefaultFilterChainBuilder
implements FilterChainBuilder {
    @Override
    public <T> Invoker<T> buildInvokerChain(Invoker<T> originalInvoker, String key, String group) {
        List filters;
        Invoker<T> last = originalInvoker;
        URL url = originalInvoker.getUrl();
        List<ModuleModel> moduleModels = this.getModuleModelsFromUrl(url);
        if (moduleModels != null && moduleModels.size() == 1) {
            filters = ScopeModelUtil.getExtensionLoader(Filter.class, (ScopeModel)((ScopeModel)moduleModels.get(0))).getActivateExtension(url, key, group);
        } else if (moduleModels != null && moduleModels.size() > 1) {
            filters = new ArrayList();
            ArrayList<ExtensionDirector> directors = new ArrayList<ExtensionDirector>();
            for (ModuleModel moduleModel : moduleModels) {
                List tempFilters = ScopeModelUtil.getExtensionLoader(Filter.class, (ScopeModel)moduleModel).getActivateExtension(url, key, group);
                filters.addAll(tempFilters);
                directors.add(moduleModel.getExtensionDirector());
            }
            filters = this.sortingAndDeduplication(filters, directors);
        } else {
            filters = ScopeModelUtil.getExtensionLoader(Filter.class, null).getActivateExtension(url, key, group);
        }
        if (!CollectionUtils.isEmpty(filters)) {
            for (int i = filters.size() - 1; i >= 0; --i) {
                Filter filter = (Filter)filters.get(i);
                Invoker<T> next = last;
                last = new FilterChainBuilder.CopyOfFilterChainNode<T, Invoker<T>, Filter>(originalInvoker, next, filter);
            }
            return new FilterChainBuilder.CallbackRegistrationInvoker(last, filters);
        }
        return last;
    }

    @Override
    public <T> ClusterInvoker<T> buildClusterInvokerChain(ClusterInvoker<T> originalInvoker, String key, String group) {
        List filters;
        ClusterInvoker<T> last = originalInvoker;
        URL url = originalInvoker.getUrl();
        List<ModuleModel> moduleModels = this.getModuleModelsFromUrl(url);
        if (moduleModels != null && moduleModels.size() == 1) {
            filters = ScopeModelUtil.getExtensionLoader(ClusterFilter.class, (ScopeModel)((ScopeModel)moduleModels.get(0))).getActivateExtension(url, key, group);
        } else if (moduleModels != null && moduleModels.size() > 1) {
            filters = new ArrayList();
            ArrayList<ExtensionDirector> directors = new ArrayList<ExtensionDirector>();
            for (ModuleModel moduleModel : moduleModels) {
                List tempFilters = ScopeModelUtil.getExtensionLoader(ClusterFilter.class, (ScopeModel)moduleModel).getActivateExtension(url, key, group);
                filters.addAll(tempFilters);
                directors.add(moduleModel.getExtensionDirector());
            }
            filters = this.sortingAndDeduplication(filters, directors);
        } else {
            filters = ScopeModelUtil.getExtensionLoader(ClusterFilter.class, null).getActivateExtension(url, key, group);
        }
        if (!CollectionUtils.isEmpty(filters)) {
            for (int i = filters.size() - 1; i >= 0; --i) {
                ClusterFilter filter = (ClusterFilter)filters.get(i);
                ClusterInvoker<T> next = last;
                last = new FilterChainBuilder.CopyOfClusterFilterChainNode<T, ClusterInvoker<T>, ClusterFilter>(originalInvoker, next, filter);
            }
            return new FilterChainBuilder.ClusterCallbackRegistrationInvoker(originalInvoker, last, filters);
        }
        return last;
    }

    private <T> List<T> sortingAndDeduplication(List<T> filters, List<ExtensionDirector> directors) {
        TreeMap filtersSet = new TreeMap((Comparator<Class<?>>)new MultiInstanceActivateComparator(directors));
        for (T filter : filters) {
            filtersSet.putIfAbsent(filter.getClass(), filter);
        }
        return new ArrayList(filtersSet.values());
    }

    private List<ModuleModel> getModuleModelsFromUrl(URL url) {
        ArrayList<ModuleModel> moduleModels = null;
        ScopeModel scopeModel = url.getScopeModel();
        if (scopeModel instanceof ApplicationModel) {
            moduleModels = ((ApplicationModel)scopeModel).getPubModuleModels();
        } else if (scopeModel instanceof ModuleModel) {
            moduleModels = new ArrayList<ModuleModel>();
            moduleModels.add((ModuleModel)scopeModel);
        }
        return moduleModels;
    }
}

