/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange.support.header;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.Parameters;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.resource.GlobalResourceInitializer;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Client;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.ExchangeChannel;
import org.apache.dubbo.remoting.exchange.ExchangeClient;
import org.apache.dubbo.remoting.exchange.ExchangeHandler;
import org.apache.dubbo.remoting.exchange.support.header.HeaderExchangeChannel;
import org.apache.dubbo.remoting.exchange.support.header.HeartbeatTimerTask;
import org.apache.dubbo.remoting.exchange.support.header.ReconnectTimerTask;
import org.apache.dubbo.remoting.utils.UrlUtils;

public class HeaderExchangeClient
implements ExchangeClient {
    private final Client client;
    private final ExchangeChannel channel;
    public static GlobalResourceInitializer<HashedWheelTimer> IDLE_CHECK_TIMER = new GlobalResourceInitializer(() -> new HashedWheelTimer((ThreadFactory)new NamedThreadFactory("dubbo-client-heartbeat-reconnect", true), 1L, TimeUnit.SECONDS, 128), HashedWheelTimer::stop);
    private ReconnectTimerTask reconnectTimerTask;
    private HeartbeatTimerTask heartBeatTimerTask;
    private final int idleTimeout;

    public HeaderExchangeClient(Client client, boolean startTimer) {
        Assert.notNull((Object)client, (String)"Client can't be null");
        this.client = client;
        this.channel = new HeaderExchangeChannel(client);
        if (startTimer) {
            URL url = client.getUrl();
            this.idleTimeout = UrlUtils.getIdleTimeout(url);
            this.startReconnectTask(url);
            this.startHeartBeatTask(url);
        } else {
            this.idleTimeout = 0;
        }
    }

    @Override
    public CompletableFuture<Object> request(Object request) throws RemotingException {
        return this.channel.request(request);
    }

    @Override
    public URL getUrl() {
        return this.channel.getUrl();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.channel.getRemoteAddress();
    }

    @Override
    public CompletableFuture<Object> request(Object request, int timeout) throws RemotingException {
        return this.channel.request(request, timeout);
    }

    @Override
    public CompletableFuture<Object> request(Object request, ExecutorService executor) throws RemotingException {
        return this.channel.request(request, executor);
    }

    @Override
    public CompletableFuture<Object> request(Object request, int timeout, ExecutorService executor) throws RemotingException {
        return this.channel.request(request, timeout, executor);
    }

    @Override
    public ChannelHandler getChannelHandler() {
        return this.channel.getChannelHandler();
    }

    @Override
    public boolean isConnected() {
        if (this.channel.isConnected()) {
            if (this.idleTimeout <= 0) {
                return true;
            }
            Long lastRead = (Long)this.channel.getAttribute("READ_TIMESTAMP");
            Long now = System.currentTimeMillis();
            return lastRead == null || now - lastRead < (long)this.idleTimeout;
        }
        return false;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    @Override
    public ExchangeHandler getExchangeHandler() {
        return this.channel.getExchangeHandler();
    }

    @Override
    public void send(Object message) throws RemotingException {
        this.channel.send(message);
    }

    @Override
    public void send(Object message, boolean sent) throws RemotingException {
        this.channel.send(message, sent);
    }

    @Override
    public boolean isClosed() {
        return this.channel.isClosed();
    }

    @Override
    public synchronized void close() {
        this.doClose();
        this.channel.close();
    }

    @Override
    public void close(int timeout) {
        this.startClose();
        this.doClose();
        this.channel.close(timeout);
    }

    @Override
    public void startClose() {
        this.channel.startClose();
    }

    public void reset(URL url) {
        this.client.reset(url);
    }

    @Override
    @Deprecated
    public void reset(Parameters parameters) {
        this.reset(this.getUrl().addParameters(parameters.getParameters()));
    }

    @Override
    public synchronized void reconnect() throws RemotingException {
        this.client.reconnect();
    }

    @Override
    public Object getAttribute(String key) {
        return this.channel.getAttribute(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.channel.setAttribute(key, value);
    }

    @Override
    public void removeAttribute(String key) {
        this.channel.removeAttribute(key);
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.channel.hasAttribute(key);
    }

    private void startHeartBeatTask(URL url) {
        if (!this.client.canHandleIdle()) {
            int heartbeat = UrlUtils.getHeartbeat(url);
            long heartbeatTick = this.calculateLeastDuration(heartbeat);
            this.heartBeatTimerTask = new HeartbeatTimerTask(() -> Collections.singleton(this), (HashedWheelTimer)IDLE_CHECK_TIMER.get(), heartbeatTick, heartbeat);
        }
    }

    private void startReconnectTask(URL url) {
        if (this.shouldReconnect(url)) {
            long heartbeatTimeoutTick = this.calculateLeastDuration(this.idleTimeout);
            this.reconnectTimerTask = new ReconnectTimerTask(() -> Collections.singleton(this), (HashedWheelTimer)IDLE_CHECK_TIMER.get(), this.calculateReconnectDuration(url, heartbeatTimeoutTick), this.idleTimeout);
        }
    }

    private void doClose() {
        if (this.heartBeatTimerTask != null) {
            this.heartBeatTimerTask.cancel();
            this.heartBeatTimerTask = null;
        }
        if (this.reconnectTimerTask != null) {
            this.reconnectTimerTask.cancel();
            this.reconnectTimerTask = null;
        }
    }

    private long calculateLeastDuration(int time) {
        if (time / 3 <= 0) {
            return 1000L;
        }
        return time / 3;
    }

    private long calculateReconnectDuration(URL url, long tick) {
        long leastReconnectDuration = url.getParameter("dubbo.application.least-reconnect-duration", 60000L);
        return Math.max(leastReconnectDuration, tick);
    }

    protected boolean shouldReconnect(URL url) {
        return !Boolean.FALSE.toString().equalsIgnoreCase(url.getParameter("reconnect"));
    }

    public String toString() {
        return "HeaderExchangeClient [channel=" + this.channel + "]";
    }
}

