/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.vector.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableIntVector;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.io.ParquetDecodingException;

final class RunLengthDecoder {
    private final boolean fixedWidth;
    private final boolean readLength;
    private ByteBufferInputStream in;
    private int bitWidth;
    private int bytesWidth;
    private BytePacker packer;
    MODE mode;
    int currentCount;
    int currentValue;
    int[] currentBuffer = new int[16];
    int currentBufferIdx = 0;

    RunLengthDecoder() {
        this.fixedWidth = false;
        this.readLength = false;
    }

    RunLengthDecoder(int bitWidth) {
        this.fixedWidth = true;
        this.readLength = bitWidth != 0;
        this.initWidthAndPacker(bitWidth);
    }

    RunLengthDecoder(int bitWidth, boolean readLength) {
        this.fixedWidth = true;
        this.readLength = readLength;
        this.initWidthAndPacker(bitWidth);
    }

    void initFromStream(int valueCount, ByteBufferInputStream in) throws IOException {
        this.in = in;
        if (this.fixedWidth) {
            if (this.readLength) {
                int length = this.readIntLittleEndian();
                this.in = in.sliceStream((long)length);
            }
        } else if (in.available() > 0) {
            this.initWidthAndPacker(in.read());
        }
        if (this.bitWidth == 0) {
            this.mode = MODE.RLE;
            this.currentCount = valueCount;
            this.currentValue = 0;
        } else {
            this.currentCount = 0;
        }
    }

    private void initWidthAndPacker(int bitWidth) {
        Preconditions.checkArgument((bitWidth >= 0 && bitWidth <= 32 ? 1 : 0) != 0, (String)"bitWidth must be >= 0 and <= 32");
        this.bitWidth = bitWidth;
        this.bytesWidth = BytesUtils.paddedByteCountFromBits((int)bitWidth);
        this.packer = Packer.LITTLE_ENDIAN.newBytePacker(bitWidth);
    }

    int readInteger() {
        if (this.currentCount == 0) {
            this.readNextGroup();
        }
        --this.currentCount;
        switch (this.mode) {
            case RLE: {
                return this.currentValue;
            }
            case PACKED: {
                return this.currentBuffer[this.currentBufferIdx++];
            }
        }
        throw new RuntimeException("Unreachable");
    }

    void readDictionaryIds(int total, WritableIntVector values, WritableColumnVector nulls, int rowId, int level, RunLengthDecoder data) {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readDictionaryIdData(n, values, rowId);
                        break;
                    }
                    nulls.setNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            values.setInt(rowId + i, data.readInteger());
                            continue;
                        }
                        nulls.setNullAt(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    private void readDictionaryIdData(int total, WritableIntVector c, int rowId) {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    c.setInts(rowId, n, this.currentValue);
                    break;
                }
                case PACKED: {
                    c.setInts(rowId, n, this.currentBuffer, this.currentBufferIdx);
                    this.currentBufferIdx += n;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    private int readUnsignedVarInt() throws IOException {
        int b;
        int value = 0;
        int shift = 0;
        do {
            b = this.in.read();
            value |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return value;
    }

    private int readIntLittleEndian() throws IOException {
        int ch4 = this.in.read();
        int ch3 = this.in.read();
        int ch2 = this.in.read();
        int ch1 = this.in.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    private int readIntLittleEndianPaddedOnBitWidth() throws IOException {
        switch (this.bytesWidth) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.in.read();
            }
            case 2: {
                int ch2 = this.in.read();
                int ch1 = this.in.read();
                return (ch1 << 8) + ch2;
            }
            case 3: {
                int ch3 = this.in.read();
                int ch2 = this.in.read();
                int ch1 = this.in.read();
                return (ch1 << 16) + (ch2 << 8) + ch3;
            }
            case 4: {
                return this.readIntLittleEndian();
            }
        }
        throw new RuntimeException("Unreachable");
    }

    void readNextGroup() {
        try {
            int header = this.readUnsignedVarInt();
            this.mode = (header & 1) == 0 ? MODE.RLE : MODE.PACKED;
            switch (this.mode) {
                case RLE: {
                    this.currentCount = header >>> 1;
                    this.currentValue = this.readIntLittleEndianPaddedOnBitWidth();
                    return;
                }
                case PACKED: {
                    int numGroups = header >>> 1;
                    this.currentCount = numGroups * 8;
                    if (this.currentBuffer.length < this.currentCount) {
                        this.currentBuffer = new int[this.currentCount];
                    }
                    this.currentBufferIdx = 0;
                    for (int valueIndex = 0; valueIndex < this.currentCount; valueIndex += 8) {
                        ByteBuffer buffer = this.in.slice(this.bitWidth);
                        this.packer.unpack8Values(buffer, buffer.position(), this.currentBuffer, valueIndex);
                    }
                    return;
                }
            }
            throw new ParquetDecodingException("not a valid mode " + (Object)((Object)this.mode));
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read from input stream", (Throwable)e);
        }
    }

    static enum MODE {
        RLE,
        PACKED;

    }
}

