/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class PipelinedRegion
implements Iterable<ExecutionVertexID> {
    private final Set<ExecutionVertexID> executionVertexIds;

    private PipelinedRegion(Set<ExecutionVertexID> executionVertexIds) {
        this.executionVertexIds = new HashSet<ExecutionVertexID>((Collection)Preconditions.checkNotNull(executionVertexIds));
    }

    public static PipelinedRegion from(Set<ExecutionVertexID> executionVertexIds) {
        return new PipelinedRegion(executionVertexIds);
    }

    public static PipelinedRegion from(ExecutionVertexID ... executionVertexIds) {
        return new PipelinedRegion(new HashSet<ExecutionVertexID>(Arrays.asList(executionVertexIds)));
    }

    public Set<ExecutionVertexID> getExecutionVertexIds() {
        return this.executionVertexIds;
    }

    public boolean contains(ExecutionVertexID executionVertexId) {
        return this.executionVertexIds.contains(executionVertexId);
    }

    @Override
    public Iterator<ExecutionVertexID> iterator() {
        return this.executionVertexIds.iterator();
    }

    public String toString() {
        return "PipelinedRegion{executionVertexIds=" + this.executionVertexIds + '}';
    }
}

