/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.messages.webmonitor.JobIdsWithStatusOverview;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJsonRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.flink.util.FlinkException;

public class CurrentJobIdsHandler
extends AbstractJsonRequestHandler {
    private final Time timeout;

    public CurrentJobIdsHandler(Executor executor, Time timeout) {
        super(executor);
        this.timeout = Objects.requireNonNull(timeout);
    }

    @Override
    public String[] getPaths() {
        return new String[]{"/jobs"};
    }

    @Override
    public CompletableFuture<String> handleJsonRequest(Map<String, String> pathParams, Map<String, String> queryParams, JobManagerGateway jobManagerGateway) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (jobManagerGateway != null) {
                    CompletableFuture<JobIdsWithStatusOverview> overviewFuture = jobManagerGateway.requestJobsOverview(this.timeout);
                    JobIdsWithStatusOverview overview = overviewFuture.get(this.timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
                    StringWriter writer = new StringWriter();
                    JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
                    gen.setCodec((ObjectCodec)RestMapperUtils.getStrictObjectMapper());
                    gen.writeStartObject();
                    gen.writeArrayFieldStart("jobs");
                    for (JobIdsWithStatusOverview.JobIdWithStatus jobIdWithStatus : overview.getJobsWithStatus()) {
                        gen.writeObject((Object)jobIdWithStatus);
                    }
                    gen.writeEndArray();
                    gen.writeEndObject();
                    gen.close();
                    return writer.toString();
                }
                throw new Exception("No connection to the leading JobManager.");
            }
            catch (Exception e) {
                throw new CompletionException(new FlinkException("Failed to fetch list of all running jobs.", (Throwable)e));
            }
        }, this.executor);
    }
}

