/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.akka;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.util.NetUtils;
import org.junit.runner.RunWith;
import org.scalactic.Equality;
import org.scalactic.Equality$;
import org.scalactic.Explicitly;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Entry;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Matchers;
import org.scalatest.Matchers$AllCollected$;
import org.scalatest.Matchers$AtLeastCollected$;
import org.scalatest.Matchers$AtMostCollected$;
import org.scalatest.Matchers$BetweenCollected$;
import org.scalatest.Matchers$EveryCollected$;
import org.scalatest.Matchers$ExactlyCollected$;
import org.scalatest.Matchers$NoCollected$;
import org.scalatest.Matchers$ShouldMethodHelper$;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Collecting;
import org.scalatest.enablers.Emptiness$;
import org.scalatest.junit.JUnitRunner;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.MatcherFactory1;
import org.scalatest.words.BeWord;
import org.scalatest.words.CompileWord;
import org.scalatest.words.ContainWord;
import org.scalatest.words.DefinedWord;
import org.scalatest.words.EmptyWord;
import org.scalatest.words.EndWithWord;
import org.scalatest.words.ExistWord;
import org.scalatest.words.FullyMatchWord;
import org.scalatest.words.HaveWord;
import org.scalatest.words.IncludeWord;
import org.scalatest.words.LengthWord;
import org.scalatest.words.MatchPatternWord;
import org.scalatest.words.MatcherWords;
import org.scalatest.words.NoExceptionWord;
import org.scalatest.words.NotWord;
import org.scalatest.words.ReadableWord;
import org.scalatest.words.ResultOfATypeInvocation;
import org.scalatest.words.ResultOfAllElementsOfApplication;
import org.scalatest.words.ResultOfAllOfApplication;
import org.scalatest.words.ResultOfAnTypeInvocation;
import org.scalatest.words.ResultOfAtLeastOneElementOfApplication;
import org.scalatest.words.ResultOfAtLeastOneOfApplication;
import org.scalatest.words.ResultOfAtMostOneElementOfApplication;
import org.scalatest.words.ResultOfAtMostOneOfApplication;
import org.scalatest.words.ResultOfDefinedAt;
import org.scalatest.words.ResultOfGreaterThanComparison;
import org.scalatest.words.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.words.ResultOfInOrderApplication;
import org.scalatest.words.ResultOfInOrderElementsOfApplication;
import org.scalatest.words.ResultOfInOrderOnlyApplication;
import org.scalatest.words.ResultOfLessThanComparison;
import org.scalatest.words.ResultOfLessThanOrEqualToComparison;
import org.scalatest.words.ResultOfMessageWordApplication;
import org.scalatest.words.ResultOfNoElementsOfApplication;
import org.scalatest.words.ResultOfNoneOfApplication;
import org.scalatest.words.ResultOfOfTypeInvocation;
import org.scalatest.words.ResultOfOneElementOfApplication;
import org.scalatest.words.ResultOfOneOfApplication;
import org.scalatest.words.ResultOfOnlyApplication;
import org.scalatest.words.ResultOfTheSameElementsAsApplication;
import org.scalatest.words.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.words.ResultOfTheTypeInvocation;
import org.scalatest.words.ResultOfThrownByApplication;
import org.scalatest.words.ShouldVerb;
import org.scalatest.words.SizeWord;
import org.scalatest.words.SortedWord;
import org.scalatest.words.StartWithWord;
import org.scalatest.words.TypeCheckWord;
import org.scalatest.words.WritableWord;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.matching.Regex;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001=2A!\u0001\u0002\u0001\u001b\ti\u0011i[6b+RLGn\u001d+fgRT!a\u0001\u0003\u0002\t\u0005\\7.\u0019\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)a\r\\5oW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u0015/A\u0011qBE\u0007\u0002!)\u0011\u0011CC\u0001\ng\u000e\fG.\u0019;fgRL!a\u0005\t\u0003\u0011\u0019+hnU;ji\u0016\u0004\"aD\u000b\n\u0005Y\u0001\"\u0001C'bi\u000eDWM]:\u0011\u0005=A\u0012BA\r\u0011\u0005E\u0011UMZ8sK\u0006sG-\u00114uKJ\fE\u000e\u001c\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAC\u0001\u0001\u0011)SA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0007eVtg.\u001a:\u000b\u0005\u0015R\u0011!\u00026v]&$\u0018BA\u0014#\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c\u0013A\u000b\t\u0003W5j\u0011\u0001\f\u0006\u0003KAI!A\f\u0017\u0003\u0017)+f.\u001b;Sk:tWM\u001d")
public class AkkaUtilsTest
extends FunSuite
implements Matchers,
BeforeAndAfterAll {
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private volatile Matchers$AllCollected$ AllCollected$module;
    private volatile Matchers$EveryCollected$ EveryCollected$module;
    private volatile Matchers$BetweenCollected$ BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ AtMostCollected$module;
    private volatile Matchers$NoCollected$ NoCollected$module;
    private volatile Matchers$ExactlyCollected$ ExactlyCollected$module;
    private volatile Matchers$ShouldMethodHelper$ ShouldMethodHelper$module;
    private final Explicitly.DecidedWord decided;
    private final Explicitly.DeterminedWord determined;
    private final Explicitly.TheAfterWord after;
    private final FullyMatchWord fullyMatch;
    private final StartWithWord startWith;
    private final EndWithWord endWith;
    private final IncludeWord include;
    private final HaveWord have;
    private final BeWord be;
    private final ContainWord contain;
    private final NotWord not;
    private final LengthWord length;
    private final SizeWord size;
    private final SortedWord sorted;
    private final DefinedWord defined;
    private final ExistWord exist;
    private final ReadableWord readable;
    private final WritableWord writable;
    private final EmptyWord empty;
    private final CompileWord compile;
    private final TypeCheckWord typeCheck;
    private final MatchPatternWord matchPattern;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.run$((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    public void afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol, Prettifier prettifier, Position pos) {
        return Matchers.convertSymbolToHavePropertyMatcherGenerator$((Matchers)this, (Symbol)symbol, (Prettifier)prettifier, (Position)pos);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.equal$((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.equal$((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.$less$((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.$greater$((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.$less$eq$((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.$greater$eq$((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.definedAt$((Matchers)this, right);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.oneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfOneElementOfApplication oneElementOf(GenTraversable<Object> elements) {
        return Matchers.oneElementOf$((Matchers)this, elements);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atLeastOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAtLeastOneElementOfApplication atLeastOneElementOf(GenTraversable<Object> elements) {
        return Matchers.atLeastOneElementOf$((Matchers)this, elements);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.noneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfNoElementsOfApplication noElementsOf(GenTraversable<Object> elements) {
        return Matchers.noElementsOf$((Matchers)this, elements);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsAs$((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsInOrderAs$((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs, Position pos) {
        return Matchers.only$((Matchers)this, xs, (Position)pos);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrderOnly$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.allOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAllElementsOfApplication allElementsOf(GenTraversable<R> elements) {
        return Matchers.allElementsOf$((Matchers)this, elements);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrder$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfInOrderElementsOfApplication inOrderElementsOf(GenTraversable<R> elements) {
        return Matchers.inOrderElementsOf$((Matchers)this, elements);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atMostOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAtMostOneElementOfApplication atMostOneElementOf(GenTraversable<R> elements) {
        return Matchers.atMostOneElementOf$((Matchers)this, elements);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.thrownBy$((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.message$((Matchers)this, (String)expectedMessage);
    }

    public <T> Assertion doCollected(Matchers.Collected collected, GenTraversable<T> xs, Object original, Prettifier prettifier, Position pos, Function1<T, Assertion> fun) {
        return Matchers.doCollected$((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (Prettifier)prettifier, (Position)pos, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <T> ResultOfATypeInvocation<T> a(ClassTag<T> evidence$5) {
        return Matchers.a$((Matchers)this, evidence$5);
    }

    public <T> ResultOfAnTypeInvocation<T> an(ClassTag<T> evidence$6) {
        return Matchers.an$((Matchers)this, evidence$6);
    }

    public <T> ResultOfTheTypeInvocation<T> the(ClassTag<T> evidence$7, Position pos) {
        return Matchers.the$((Matchers)this, evidence$7, (Position)pos);
    }

    public <T> Matchers.AnyShouldWrapper<T> convertToAnyShouldWrapper(T o, Position pos, Prettifier prettifier) {
        return Matchers.convertToAnyShouldWrapper$((Matchers)this, o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.StringShouldWrapper convertToStringShouldWrapper(String o, Position pos, Prettifier prettifier) {
        return Matchers.convertToStringShouldWrapper$((Matchers)this, (String)o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.convertToRegexWrapper$((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(ClassTag<T> ev) {
        return Matchers.of$((Matchers)this, ev);
    }

    public NoExceptionWord noException(Position pos) {
        return MatcherWords.noException$((MatcherWords)this, (Position)pos);
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.equal$((MatcherWords)this, (Object)right);
    }

    public ShouldVerb.StringShouldWrapperForVerb convertToStringShouldWrapperForVerb(String o, Position position) {
        return ShouldVerb.convertToStringShouldWrapperForVerb$((ShouldVerb)this, (String)o, (Position)position);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.convertNumericToPlusOrMinusWrapper$((Tolerance)this, pivot, evidence$2);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    public Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected() {
        if (this.AllCollected$module == null) {
            this.org$scalatest$Matchers$$AllCollected$lzycompute$1();
        }
        return this.AllCollected$module;
    }

    public Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected() {
        if (this.EveryCollected$module == null) {
            this.org$scalatest$Matchers$$EveryCollected$lzycompute$1();
        }
        return this.EveryCollected$module;
    }

    public Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected() {
        if (this.BetweenCollected$module == null) {
            this.org$scalatest$Matchers$$BetweenCollected$lzycompute$1();
        }
        return this.BetweenCollected$module;
    }

    public Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected() {
        if (this.AtLeastCollected$module == null) {
            this.org$scalatest$Matchers$$AtLeastCollected$lzycompute$1();
        }
        return this.AtLeastCollected$module;
    }

    public Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected() {
        if (this.AtMostCollected$module == null) {
            this.org$scalatest$Matchers$$AtMostCollected$lzycompute$1();
        }
        return this.AtMostCollected$module;
    }

    public Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected() {
        if (this.NoCollected$module == null) {
            this.org$scalatest$Matchers$$NoCollected$lzycompute$1();
        }
        return this.NoCollected$module;
    }

    public Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected() {
        if (this.ExactlyCollected$module == null) {
            this.org$scalatest$Matchers$$ExactlyCollected$lzycompute$1();
        }
        return this.ExactlyCollected$module;
    }

    public Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper() {
        if (this.ShouldMethodHelper$module == null) {
            this.org$scalatest$Matchers$$ShouldMethodHelper$lzycompute$1();
        }
        return this.ShouldMethodHelper$module;
    }

    public void org$scalatest$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$words$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    private final void org$scalatest$Matchers$$AllCollected$lzycompute$1() {
        AkkaUtilsTest akkaUtilsTest = this;
        synchronized (akkaUtilsTest) {
            if (this.AllCollected$module == null) {
                this.AllCollected$module = new Matchers$AllCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$EveryCollected$lzycompute$1() {
        AkkaUtilsTest akkaUtilsTest = this;
        synchronized (akkaUtilsTest) {
            if (this.EveryCollected$module == null) {
                this.EveryCollected$module = new Matchers$EveryCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$BetweenCollected$lzycompute$1() {
        AkkaUtilsTest akkaUtilsTest = this;
        synchronized (akkaUtilsTest) {
            if (this.BetweenCollected$module == null) {
                this.BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$AtLeastCollected$lzycompute$1() {
        AkkaUtilsTest akkaUtilsTest = this;
        synchronized (akkaUtilsTest) {
            if (this.AtLeastCollected$module == null) {
                this.AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$AtMostCollected$lzycompute$1() {
        AkkaUtilsTest akkaUtilsTest = this;
        synchronized (akkaUtilsTest) {
            if (this.AtMostCollected$module == null) {
                this.AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$NoCollected$lzycompute$1() {
        AkkaUtilsTest akkaUtilsTest = this;
        synchronized (akkaUtilsTest) {
            if (this.NoCollected$module == null) {
                this.NoCollected$module = new Matchers$NoCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$ExactlyCollected$lzycompute$1() {
        AkkaUtilsTest akkaUtilsTest = this;
        synchronized (akkaUtilsTest) {
            if (this.ExactlyCollected$module == null) {
                this.ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$ShouldMethodHelper$lzycompute$1() {
        AkkaUtilsTest akkaUtilsTest = this;
        synchronized (akkaUtilsTest) {
            if (this.ShouldMethodHelper$module == null) {
                this.ShouldMethodHelper$module = new Matchers$ShouldMethodHelper$((Matchers)this);
            }
        }
    }

    public AkkaUtilsTest() {
        Tolerance.$init$((Tolerance)this);
        ShouldVerb.$init$((ShouldVerb)this);
        MatcherWords.$init$((MatcherWords)this);
        Explicitly.$init$((Explicitly)this);
        Matchers.$init$((Matchers)this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        this.test("getAkkaConfig should validate transport heartbeats", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Configuration configuration = new Configuration();
            configuration.setString(AkkaOptions.TRANSPORT_HEARTBEAT_PAUSE.key(), (String)AkkaOptions.TRANSPORT_HEARTBEAT_INTERVAL.defaultValue());
            return (IllegalConfigurationException)this.intercept((Function0 & Serializable & scala.Serializable)() -> AkkaUtils$.MODULE$.getAkkaConfig(configuration, (Option)new Some((Object)new Tuple2((Object)"localhost", (Object)BoxesRunTime.boxToInteger((int)31337)))), ClassTag$.MODULE$.apply(IllegalConfigurationException.class), new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 45));
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 40));
        this.test("getHostFromAkkaURL should return the correct host from a remote Akka URL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String host = "127.0.0.1";
            int port = 1234;
            InetSocketAddress address = new InetSocketAddress(host, port);
            String remoteAkkaUrl = AkkaRpcServiceUtils.getRpcUrl((String)host, (int)port, (String)"actor", (HighAvailabilityServicesUtils.AddressResolution)HighAvailabilityServicesUtils.AddressResolution.NO_ADDRESS_RESOLUTION, (AkkaRpcServiceUtils.AkkaProtocol)AkkaRpcServiceUtils.AkkaProtocol.TCP);
            InetSocketAddress result = AkkaUtils$.MODULE$.getInetSocketAddressFromAkkaURL(remoteAkkaUrl);
            return this.convertToAnyShouldWrapper(result, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 65), Prettifier$.MODULE$.default()).should(this.equal(address), (Object)Equality$.MODULE$.default());
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 50));
        this.test("getHostFromAkkaURL should throw an exception if the InetSocketAddress cannot be retrieved", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String localAkkaURL = AkkaUtils$.MODULE$.getLocalAkkaURL("actor");
            return (Exception)this.intercept((Function0 & Serializable & scala.Serializable)() -> AkkaUtils$.MODULE$.getInetSocketAddressFromAkkaURL(localAkkaURL), ClassTag$.MODULE$.apply(Exception.class), new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 72));
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 69));
        this.test("getHostFromAkkaURL should return host after at sign", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String url = "akka://flink@localhost:1234/user/jobmanager";
            InetSocketAddress expected = new InetSocketAddress("localhost", 1234);
            InetSocketAddress result = AkkaUtils$.MODULE$.getInetSocketAddressFromAkkaURL(url);
            return this.convertToAnyShouldWrapper(result, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 83), Prettifier$.MODULE$.default()).should(this.equal(expected), (Object)Equality$.MODULE$.default());
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 77));
        this.test("getHostFromAkkaURL should handle 'akka.tcp' as protocol", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String url = "akka.tcp://flink@localhost:1234/user/jobmanager";
            InetSocketAddress expected = new InetSocketAddress("localhost", 1234);
            InetSocketAddress result = AkkaUtils$.MODULE$.getInetSocketAddressFromAkkaURL(url);
            return this.convertToAnyShouldWrapper(result, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 92), Prettifier$.MODULE$.default()).should(this.equal(expected), (Object)Equality$.MODULE$.default());
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 86));
        this.test("getHostFromAkkaURL should handle 'akka.ssl.tcp' as protocol", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String url = "akka.ssl.tcp://flink@localhost:1234/user/jobmanager";
            InetSocketAddress expected = new InetSocketAddress("localhost", 1234);
            InetSocketAddress result = AkkaUtils$.MODULE$.getInetSocketAddressFromAkkaURL(url);
            return this.convertToAnyShouldWrapper(result, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 101), Prettifier$.MODULE$.default()).should(this.equal(expected), (Object)Equality$.MODULE$.default());
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 95));
        this.test("getHostFromAkkaURL should properly handle IPv4 addresses in URLs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String IPv4AddressString = "192.168.0.1";
            int port = 1234;
            InetSocketAddress address = new InetSocketAddress(IPv4AddressString, port);
            String url = new StringBuilder(30).append("akka://flink@").append(IPv4AddressString).append(":").append(port).append("/user/jobmanager").toString();
            InetSocketAddress result = AkkaUtils$.MODULE$.getInetSocketAddressFromAkkaURL(url);
            return this.convertToAnyShouldWrapper(result, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 113), Prettifier$.MODULE$.default()).should(this.equal(address), (Object)Equality$.MODULE$.default());
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 104));
        this.test("getHostFromAkkaURL should properly handle IPv6 addresses in URLs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String IPv6AddressString = "2001:db8:10:11:12:ff00:42:8329";
            int port = 1234;
            InetSocketAddress address = new InetSocketAddress(IPv6AddressString, port);
            String url = new StringBuilder(32).append("akka://flink@[").append(IPv6AddressString).append("]:").append(port).append("/user/jobmanager").toString();
            InetSocketAddress result = AkkaUtils$.MODULE$.getInetSocketAddressFromAkkaURL(url);
            return this.convertToAnyShouldWrapper(result, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 125), Prettifier$.MODULE$.default()).should(this.equal(address), (Object)Equality$.MODULE$.default());
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 116));
        this.test("getHostFromAkkaURL should properly handle IPv6 addresses in 'akka.tcp' URLs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String IPv6AddressString = "2001:db8:10:11:12:ff00:42:8329";
            int port = 1234;
            InetSocketAddress address = new InetSocketAddress(IPv6AddressString, port);
            String url = new StringBuilder(36).append("akka.tcp://flink@[").append(IPv6AddressString).append("]:").append(port).append("/user/jobmanager").toString();
            InetSocketAddress result = AkkaUtils$.MODULE$.getInetSocketAddressFromAkkaURL(url);
            return this.convertToAnyShouldWrapper(result, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 137), Prettifier$.MODULE$.default()).should(this.equal(address), (Object)Equality$.MODULE$.default());
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 128));
        this.test("getHostFromAkkaURL should properly handle IPv6 addresses in 'akka.ssl.tcp' URLs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String IPv6AddressString = "2001:db8:10:11:12:ff00:42:8329";
            int port = 1234;
            InetSocketAddress address = new InetSocketAddress(IPv6AddressString, port);
            String url = new StringBuilder(40).append("akka.ssl.tcp://flink@[").append(IPv6AddressString).append("]:").append(port).append("/user/jobmanager").toString();
            InetSocketAddress result = AkkaUtils$.MODULE$.getInetSocketAddressFromAkkaURL(url);
            return this.convertToAnyShouldWrapper(result, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 149), Prettifier$.MODULE$.default()).should(this.equal(address), (Object)Equality$.MODULE$.default());
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 140));
        this.test("getAkkaConfig should normalize the hostname", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Configuration configuration = new Configuration();
            String hostname = "AbC123foOBaR";
            int port = 1234;
            Config akkaConfig = AkkaUtils$.MODULE$.getAkkaConfig(configuration, hostname, port);
            return this.convertToStringShouldWrapper(akkaConfig.getString("akka.remote.netty.tcp.hostname"), new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 159), Prettifier$.MODULE$.default()).should(this.equal(NetUtils.unresolvedHostToNormalizedString((String)hostname)), (Object)Equality$.MODULE$.default());
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 152));
        this.test("null hostname should go to localhost", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Config configure = AkkaUtils$.MODULE$.getAkkaConfig(new Configuration(), (Option)new Some((Object)new Tuple2(null, (Object)BoxesRunTime.boxToInteger((int)1772))));
            String hostname = configure.getString("akka.remote.netty.tcp.hostname");
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)InetAddress.getByName(hostname).isLoopbackAddress()), new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 168), Prettifier$.MODULE$.default()).should(this.be().apply(true));
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 163));
        this.test("getAkkaConfig defaults to fork-join-executor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Config akkaConfig = AkkaUtils$.MODULE$.getAkkaConfig(new Configuration());
            return this.convertToStringShouldWrapper(akkaConfig.getString("akka.actor.default-dispatcher.executor"), new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 174), Prettifier$.MODULE$.default()).should(this.equal("fork-join-executor"), (Object)Equality$.MODULE$.default());
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 171));
        this.test("getAkkaConfig sets executor with thread priority", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int threadPriority = 3;
            int minThreads = 1;
            int maxThreads = 3;
            Config akkaConfig = AkkaUtils$.MODULE$.getAkkaConfig(new Configuration(), "localhost", 1234, AkkaUtils$.MODULE$.getThreadPoolExecutorConfig(new BootstrapTools.FixedThreadPoolExecutorConfiguration(minThreads, maxThreads, threadPriority)));
            this.convertToStringShouldWrapper(akkaConfig.getString("akka.actor.default-dispatcher.executor"), new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 190), Prettifier$.MODULE$.default()).should(this.equal("thread-pool-executor"), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)akkaConfig.getInt("akka.actor.default-dispatcher.thread-priority")), new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 193), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)threadPriority)), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)akkaConfig.getInt("akka.actor.default-dispatcher.thread-pool-executor.core-pool-size-min")), new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 195), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)minThreads)), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)akkaConfig.getInt("akka.actor.default-dispatcher.thread-pool-executor.core-pool-size-max")), new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 197), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)maxThreads)), (Object)Equality$.MODULE$.default());
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 178));
        this.test("getAkkaConfig should work with ipv6 addresses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String ipv6AddressString = "2001:db8:10:11:12:ff00:42:8329";
            Configuration configuration = new Configuration();
            int port = 1234;
            Config akkaConfig = AkkaUtils$.MODULE$.getAkkaConfig(configuration, ipv6AddressString, port);
            return this.convertToStringShouldWrapper(akkaConfig.getString("akka.remote.netty.tcp.hostname"), new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 208), Prettifier$.MODULE$.default()).should(this.equal(NetUtils.unresolvedHostToNormalizedString((String)ipv6AddressString)), (Object)Equality$.MODULE$.default());
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 201));
        this.test("getAkkaConfig should set startup timeout to be 10 times of ask timeout by default", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Configuration configuration = new Configuration();
            configuration.setString(AkkaOptions.ASK_TIMEOUT.key(), "100ms");
            Config akkaConfig = AkkaUtils$.MODULE$.getAkkaConfig(configuration, (Option)new Some((Object)new Tuple2((Object)"localhost", (Object)BoxesRunTime.boxToInteger((int)31337))));
            return this.convertToStringShouldWrapper(akkaConfig.getString("akka.remote.startup-timeout"), new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 218), Prettifier$.MODULE$.default()).should(this.equal("1000ms"), (Object)Equality$.MODULE$.default());
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 212));
        this.test("getAkkaConfig for ssl engine provider without cert fingerprint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Configuration configuration = new Configuration();
            configuration.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, true);
            Config akkaConfig = AkkaUtils$.MODULE$.getAkkaConfig(configuration, (Option)new Some((Object)new Tuple2((Object)"localhost", (Object)BoxesRunTime.boxToInteger((int)31337))));
            Config sslConfig = akkaConfig.getConfig("akka.remote.netty.ssl");
            this.convertToStringShouldWrapper(sslConfig.getString("ssl-engine-provider"), new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 230), Prettifier$.MODULE$.default()).should(this.equal("org.apache.flink.runtime.akka.CustomSSLEngineProvider"), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(sslConfig.getStringList("security.cert-fingerprints"), new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 233), Prettifier$.MODULE$.default()).shouldBe(this.empty(), Emptiness$.MODULE$.emptinessOfJavaCollection());
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 222));
        this.test("getAkkaConfig for ssl engine provider with cert fingerprint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Configuration configuration = new Configuration();
            configuration.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, true);
            String fingerprint = "A8:98:5D:3A:65:E5:E5:C4:B2:D7:D6:6D:40:C6:DD:2F:B1:9C:54:36";
            configuration.setString(SecurityOptions.SSL_INTERNAL_CERT_FINGERPRINT, fingerprint);
            Config akkaConfig = AkkaUtils$.MODULE$.getAkkaConfig(configuration, (Option)new Some((Object)new Tuple2((Object)"localhost", (Object)BoxesRunTime.boxToInteger((int)31337))));
            Config sslConfig = akkaConfig.getConfig("akka.remote.netty.ssl");
            this.convertToStringShouldWrapper(sslConfig.getString("ssl-engine-provider"), new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 247), Prettifier$.MODULE$.default()).should(this.equal("org.apache.flink.runtime.akka.CustomSSLEngineProvider"), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(sslConfig.getStringList("security.cert-fingerprints"), new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 250), Prettifier$.MODULE$.default()).should(this.equal(Collections.singletonList(fingerprint)), (Object)Equality$.MODULE$.default());
        }, new Position("AkkaUtilsTest.scala", "/home/chesnay/flink/flink-runtime/src/test/scala/org/apache/flink/runtime/akka/AkkaUtilsTest.scala", 236));
    }
}

