/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.dispatcher.SchedulerNGFactoryFactory;
import org.apache.flink.runtime.scheduler.DefaultSchedulerFactory;
import org.apache.flink.runtime.scheduler.SchedulerNGFactory;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SchedulerNGFactoryFactoryTest
extends TestLogger {
    @Test
    public void createDefaultSchedulerFactoryByDefault() {
        SchedulerNGFactory schedulerNGFactory = SchedulerNGFactoryFactoryTest.createSchedulerNGFactory(new Configuration());
        Assert.assertThat((Object)schedulerNGFactory, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultSchedulerFactory.class)));
    }

    @Test
    public void createSchedulerNGFactoryIfConfigured() {
        Configuration configuration = new Configuration();
        configuration.setString(JobManagerOptions.SCHEDULER, "ng");
        SchedulerNGFactory schedulerNGFactory = SchedulerNGFactoryFactoryTest.createSchedulerNGFactory(configuration);
        Assert.assertThat((Object)schedulerNGFactory, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultSchedulerFactory.class)));
    }

    @Test
    public void throwsExceptionIfSchedulerNameIsInvalid() {
        Configuration configuration = new Configuration();
        configuration.setString(JobManagerOptions.SCHEDULER, "invalid-scheduler-name");
        try {
            SchedulerNGFactoryFactoryTest.createSchedulerNGFactory(configuration);
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Illegal value [invalid-scheduler-name]"));
        }
    }

    private static SchedulerNGFactory createSchedulerNGFactory(Configuration configuration) {
        return SchedulerNGFactoryFactory.createSchedulerNGFactory((Configuration)configuration);
    }
}

