/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.util.function.BiFunctionWithException;

public class TestingClassLoaderLease
implements LibraryCacheManager.ClassLoaderLease {
    private final BiFunctionWithException<Collection<PermanentBlobKey>, Collection<URL>, ClassLoader, IOException> getOrResolveClassLoaderFunction;
    private final Runnable closeRunnable;

    public TestingClassLoaderLease(BiFunctionWithException<Collection<PermanentBlobKey>, Collection<URL>, ClassLoader, IOException> getOrResolveClassLoaderFunction, Runnable closeRunnable) {
        this.getOrResolveClassLoaderFunction = getOrResolveClassLoaderFunction;
        this.closeRunnable = closeRunnable;
    }

    public ClassLoader getOrResolveClassLoader(Collection<PermanentBlobKey> requiredJarFiles, Collection<URL> requiredClasspaths) throws IOException {
        return (ClassLoader)this.getOrResolveClassLoaderFunction.apply(requiredJarFiles, requiredClasspaths);
    }

    public void release() {
        this.closeRunnable.run();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private BiFunctionWithException<Collection<PermanentBlobKey>, Collection<URL>, ClassLoader, IOException> getOrResolveClassLoaderFunction = (ignoredA, ignoredB) -> Builder.class.getClassLoader();
        private Runnable closeRunnable = () -> {};

        private Builder() {
        }

        public Builder setGetOrResolveClassLoaderFunction(BiFunctionWithException<Collection<PermanentBlobKey>, Collection<URL>, ClassLoader, IOException> getOrResolveClassLoaderFunction) {
            this.getOrResolveClassLoaderFunction = getOrResolveClassLoaderFunction;
            return this;
        }

        public Builder setCloseRunnable(Runnable closeRunnable) {
            this.closeRunnable = closeRunnable;
            return this;
        }

        public TestingClassLoaderLease build() {
            return new TestingClassLoaderLease(this.getOrResolveClassLoaderFunction, this.closeRunnable);
        }
    }
}

