/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.TestingExecutionGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.testutils.DirectScheduledExecutorService;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionJobVertexTest {
    private static final int NOT_CONFIGURED = -1;

    @Test
    public void testMaxParallelismDefaulting() throws Exception {
        ExecutionJobVertex executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(1, -1);
        Assert.assertEquals((long)128L, (long)executionJobVertex.getMaxParallelism());
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(171, -1);
        Assert.assertEquals((long)256L, (long)executionJobVertex.getMaxParallelism());
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(172, -1);
        Assert.assertEquals((long)512L, (long)executionJobVertex.getMaxParallelism());
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(32768, -1);
        Assert.assertEquals((long)32768L, (long)executionJobVertex.getMaxParallelism());
        try {
            executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(32769, -1);
            executionJobVertex.getMaxParallelism();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ExecutionJobVertexTest.createExecutionJobVertex(172, 4);
            Assert.fail((String)"We should not be able to create an ExecutionJobVertex which has a smaller max parallelism than parallelism.");
        }
        catch (JobException jobException) {
            // empty catch block
        }
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(4, 32768);
        Assert.assertEquals((long)32768L, (long)executionJobVertex.getMaxParallelism());
        try {
            executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(4, 32769);
            Assert.fail((String)String.valueOf(executionJobVertex.getMaxParallelism()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(4, 0);
            Assert.fail((String)String.valueOf(executionJobVertex.getMaxParallelism()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(4, -1);
        executionJobVertex.setMaxParallelism(7);
        Assert.assertEquals((long)7L, (long)executionJobVertex.getMaxParallelism());
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(4, -1);
        try {
            executionJobVertex.setMaxParallelism(0);
            Assert.fail((String)String.valueOf(executionJobVertex.getMaxParallelism()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(4, -1);
        try {
            executionJobVertex.setMaxParallelism(32769);
            Assert.fail((String)String.valueOf(executionJobVertex.getMaxParallelism()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(4, 16);
        try {
            executionJobVertex.setMaxParallelism(7);
            Assert.fail((String)String.valueOf(executionJobVertex.getMaxParallelism()));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static ExecutionJobVertex createExecutionJobVertex(int parallelism, int preconfiguredMaxParallelism) throws JobException, JobExecutionException {
        JobVertex jobVertex = new JobVertex("testVertex");
        jobVertex.setInvokableClass(AbstractInvokable.class);
        jobVertex.setParallelism(parallelism);
        if (-1 != preconfiguredMaxParallelism) {
            jobVertex.setMaxParallelism(preconfiguredMaxParallelism);
        }
        ExecutionGraph executionGraph = ExecutionJobVertexTest.createExecutionGraph();
        return new ExecutionJobVertex(executionGraph, jobVertex, 1, Time.seconds((long)10L));
    }

    private static ExecutionGraph createExecutionGraph() throws JobException, JobExecutionException {
        ExecutionGraph executionGraph = TestingExecutionGraphBuilder.newBuilder().setFutureExecutor(new DirectScheduledExecutorService()).build();
        executionGraph.transitionToRunning();
        return executionGraph;
    }
}

