/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.executiongraph.restart.RestartCallback;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;

public class TestRestartStrategy
implements RestartStrategy {
    @Nonnull
    private final Queue<ExecutorAction> actionsQueue;
    private final int maxRestarts;
    private int restartAttempts;
    private boolean manuallyTriggeredExecution;

    public TestRestartStrategy() {
        this(true);
    }

    public TestRestartStrategy(boolean manuallyTriggeredExecution) {
        this(-1, manuallyTriggeredExecution);
    }

    public TestRestartStrategy(int maxRestarts, boolean manuallyTriggeredExecution) {
        this(new LinkedList<ExecutorAction>(), maxRestarts, manuallyTriggeredExecution);
    }

    public TestRestartStrategy(@Nonnull Queue<ExecutorAction> actionsQueue, int maxRestarts, boolean manuallyTriggeredExecution) {
        this.actionsQueue = actionsQueue;
        this.maxRestarts = maxRestarts;
        this.manuallyTriggeredExecution = manuallyTriggeredExecution;
    }

    public boolean canRestart() {
        return this.maxRestarts < 0 || this.maxRestarts - this.restartAttempts > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> restart(RestartCallback restarter, ScheduledExecutor executor) {
        ++this.restartAttempts;
        ExecutorAction executorAction = new ExecutorAction(() -> ((RestartCallback)restarter).triggerFullRecovery(), (Executor)executor);
        if (this.manuallyTriggeredExecution) {
            Queue<ExecutorAction> queue = this.actionsQueue;
            synchronized (queue) {
                this.actionsQueue.add(executorAction);
            }
            return new CompletableFuture<Void>();
        }
        return executorAction.trigger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfQueuedActions() {
        Queue<ExecutorAction> queue = this.actionsQueue;
        synchronized (queue) {
            return this.actionsQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> triggerNextAction() {
        Queue<ExecutorAction> queue = this.actionsQueue;
        synchronized (queue) {
            return this.actionsQueue.remove().trigger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> triggerAll() {
        Queue<ExecutorAction> queue = this.actionsQueue;
        synchronized (queue) {
            if (this.actionsQueue.isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture[] completableFutures = new CompletableFuture[this.actionsQueue.size()];
            for (int i = 0; i < completableFutures.length; ++i) {
                completableFutures[i] = this.triggerNextAction();
            }
            return CompletableFuture.allOf(completableFutures);
        }
    }

    public boolean isManuallyTriggeredExecution() {
        return this.manuallyTriggeredExecution;
    }

    public void setManuallyTriggeredExecution(boolean manuallyTriggeredExecution) {
        this.manuallyTriggeredExecution = manuallyTriggeredExecution;
    }

    public static TestRestartStrategy manuallyTriggered() {
        return new TestRestartStrategy(true);
    }

    public static TestRestartStrategy directExecuting() {
        return new TestRestartStrategy(false);
    }

    private static class ExecutorAction {
        final Runnable runnable;
        final Executor executor;

        ExecutorAction(Runnable runnable, Executor executor) {
            this.runnable = runnable;
            this.executor = executor;
        }

        public CompletableFuture<Void> trigger() {
            return CompletableFuture.runAsync(this.runnable, this.executor);
        }
    }
}

