/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.util.Preconditions;

public class TestingSlotProvider
implements SlotProvider {
    private final ConcurrentMap<SlotRequestId, CompletableFuture<LogicalSlot>> slotFutures;
    private final Function<SlotRequestId, CompletableFuture<LogicalSlot>> slotFutureCreator;
    private volatile Consumer<SlotRequestId> slotCanceller = ignored -> {};

    public TestingSlotProvider(Function<SlotRequestId, CompletableFuture<LogicalSlot>> slotFutureCreator) {
        this.slotFutureCreator = slotFutureCreator;
        this.slotFutures = new ConcurrentHashMap<SlotRequestId, CompletableFuture<LogicalSlot>>(4);
    }

    public void setSlotCanceller(Consumer<SlotRequestId> slotCanceller) {
        this.slotCanceller = slotCanceller;
    }

    public CompletableFuture<LogicalSlot> allocateSlot(SlotRequestId slotRequestId, ScheduledUnit task, SlotProfile slotProfile, Time timeout) {
        Preconditions.checkState((!this.slotFutures.containsKey(slotRequestId) ? 1 : 0) != 0);
        CompletableFuture<LogicalSlot> slotFuture = this.slotFutureCreator.apply(slotRequestId);
        this.slotFutures.put(slotRequestId, slotFuture);
        return slotFuture;
    }

    public void cancelSlotRequest(SlotRequestId slotRequestId, @Nullable SlotSharingGroupId slotSharingGroupId, Throwable cause) {
        CompletableFuture slotFuture = (CompletableFuture)this.slotFutures.remove(slotRequestId);
        slotFuture.cancel(false);
        this.slotCanceller.accept(slotRequestId);
    }

    public void complete(SlotRequestId slotRequestId, LogicalSlot logicalSlot) {
        ((CompletableFuture)this.slotFutures.get(slotRequestId)).complete(logicalSlot);
    }
}

