/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnegative;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.executiongraph.restart.RestartCallback;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.util.FlinkRuntimeException;

public class FailingRestartStrategy
implements RestartStrategy {
    public static final ConfigOption<Integer> NUM_FAILURES_CONFIG_OPTION = ConfigOptions.key((String)"restart-strategy.failing.failures").defaultValue((Object)1);
    private final int numberOfFailures;
    private int restartedTimes;

    public FailingRestartStrategy(@Nonnegative int numberOfFailures) {
        this.numberOfFailures = numberOfFailures;
    }

    public boolean canRestart() {
        return true;
    }

    public CompletableFuture<Void> restart(RestartCallback restarter, ScheduledExecutor executor) {
        ++this.restartedTimes;
        if (this.restartedTimes <= this.numberOfFailures) {
            return FutureUtils.completedExceptionally((Throwable)new FlinkRuntimeException("Fail to restart for " + this.restartedTimes + " time(s)."));
        }
        return FutureUtils.scheduleWithDelay(() -> ((RestartCallback)restarter).triggerFullRecovery(), (Time)Time.milliseconds((long)0L), (ScheduledExecutor)executor);
    }

    public static FailingRestartStrategyFactory createFactory(Configuration configuration) {
        int numberOfFailures = configuration.getInteger(NUM_FAILURES_CONFIG_OPTION);
        return new FailingRestartStrategyFactory(numberOfFailures);
    }

    public static class FailingRestartStrategyFactory
    extends RestartStrategyFactory {
        private static final long serialVersionUID = 1L;
        private final int numberOfFailures;

        public FailingRestartStrategyFactory(int numberOfFailures) {
            this.numberOfFailures = numberOfFailures;
        }

        public RestartStrategy createRestartStrategy() {
            return new FailingRestartStrategy(this.numberOfFailures);
        }
    }
}

