/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.EndOfSuperstepEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.util.TestTaskEvent;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.junit.Assert;
import org.junit.Test;

public class EventSerializerTest {
    private final AbstractEvent[] events = new AbstractEvent[]{EndOfPartitionEvent.INSTANCE, EndOfSuperstepEvent.INSTANCE, new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions(CheckpointType.CHECKPOINT, CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions(CheckpointType.SAVEPOINT, CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions(CheckpointType.SAVEPOINT_SUSPEND, CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions(CheckpointType.SAVEPOINT_TERMINATE, CheckpointStorageLocationReference.getDefault())), new TestTaskEvent(Math.random(), 12361231273L), new CancelCheckpointMarker(287087987329842L)};

    @Test
    public void testSerializeDeserializeEvent() throws Exception {
        for (AbstractEvent evt : this.events) {
            ByteBuffer serializedEvent = EventSerializer.toSerializedEvent((AbstractEvent)evt);
            Assert.assertTrue((boolean)serializedEvent.hasRemaining());
            AbstractEvent deserialized = EventSerializer.fromSerializedEvent((ByteBuffer)serializedEvent, (ClassLoader)this.getClass().getClassLoader());
            Assert.assertNotNull((Object)deserialized);
            Assert.assertEquals((Object)evt, (Object)deserialized);
        }
    }

    @Test
    public void testToBufferConsumer() throws IOException {
        for (AbstractEvent evt : this.events) {
            BufferConsumer bufferConsumer = EventSerializer.toBufferConsumer((AbstractEvent)evt);
            Assert.assertFalse((boolean)bufferConsumer.isBuffer());
            Assert.assertTrue((boolean)bufferConsumer.isFinished());
            Assert.assertTrue((boolean)bufferConsumer.isDataAvailable());
            Assert.assertFalse((boolean)bufferConsumer.isRecycled());
            if (evt instanceof CheckpointBarrier) {
                Assert.assertTrue((boolean)bufferConsumer.build().getDataType().isBlockingUpstream());
                continue;
            }
            Assert.assertEquals((Object)Buffer.DataType.EVENT_BUFFER, (Object)bufferConsumer.build().getDataType());
        }
    }

    @Test
    public void testToBuffer() throws IOException {
        for (AbstractEvent evt : this.events) {
            Buffer buffer = EventSerializer.toBuffer((AbstractEvent)evt);
            Assert.assertFalse((boolean)buffer.isBuffer());
            Assert.assertTrue((buffer.readableBytes() > 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)buffer.isRecycled());
            if (evt instanceof CheckpointBarrier) {
                Assert.assertTrue((boolean)buffer.getDataType().isBlockingUpstream());
                continue;
            }
            Assert.assertEquals((Object)Buffer.DataType.EVENT_BUFFER, (Object)buffer.getDataType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsEventPeakOnly() throws Exception {
        Buffer serializedEvent = EventSerializer.toBuffer((AbstractEvent)EndOfPartitionEvent.INSTANCE);
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Assert.assertTrue((boolean)EventSerializer.isEvent((Buffer)serializedEvent, EndOfPartitionEvent.class));
            EndOfPartitionEvent event = (EndOfPartitionEvent)EventSerializer.fromBuffer((Buffer)serializedEvent, (ClassLoader)cl);
            Assert.assertEquals((Object)EndOfPartitionEvent.INSTANCE, (Object)event);
        }
        finally {
            serializedEvent.recycleBuffer();
        }
    }

    @Test
    public void testIsEvent() throws Exception {
        Class[] expectedClasses = (Class[])Arrays.stream(this.events).map(Object::getClass).toArray(Class[]::new);
        for (AbstractEvent evt : this.events) {
            for (Class expectedClass : expectedClasses) {
                if (expectedClass.equals(TestTaskEvent.class)) {
                    try {
                        this.checkIsEvent(evt, expectedClass);
                        Assert.fail((String)"This should fail");
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {}
                    continue;
                }
                if (evt.getClass().equals(expectedClass)) {
                    Assert.assertTrue((boolean)this.checkIsEvent(evt, expectedClass));
                    continue;
                }
                Assert.assertFalse((boolean)this.checkIsEvent(evt, expectedClass));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIsEvent(AbstractEvent event, Class<?> eventClass) throws IOException {
        Buffer serializedEvent = EventSerializer.toBuffer((AbstractEvent)event);
        try {
            boolean bl = EventSerializer.isEvent((Buffer)serializedEvent, eventClass);
            return bl;
        }
        finally {
            serializedEvent.recycleBuffer();
        }
    }
}

