/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import java.util.List;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.SpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.api.writer.AbstractCollectingResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.types.Record;
import org.apache.flink.util.Preconditions;

public class RecordCollectingResultPartitionWriter
extends AbstractCollectingResultPartitionWriter {
    private final List<Record> output;
    private final Record record = new Record();
    private final RecordDeserializer<Record> deserializer = new SpillingAdaptiveSpanningRecordDeserializer(new String[]{System.getProperty("java.io.tmpdir")});

    public RecordCollectingResultPartitionWriter(List<Record> output, BufferProvider bufferProvider) {
        super(bufferProvider);
        this.output = (List)Preconditions.checkNotNull(output);
    }

    @Override
    protected void deserializeBuffer(Buffer buffer) throws IOException {
        this.deserializer.setNextBuffer(buffer);
        while (this.deserializer.hasUnfinishedData()) {
            RecordDeserializer.DeserializationResult result = this.deserializer.getNextRecord((IOReadableWritable)this.record);
            if (result.isFullRecord()) {
                this.output.add(this.record.createCopy());
            }
            if (result != RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER && result != RecordDeserializer.DeserializationResult.PARTIAL_RECORD) continue;
            break;
        }
    }
}

