/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;

class AwaitableBufferAvailablityListener
implements BufferAvailabilityListener {
    private final AtomicLong numNotifications = new AtomicLong();
    private final AtomicLong numPriorityEvents = new AtomicLong();
    private final AtomicBoolean consumePriorityEvents = new AtomicBoolean();

    AwaitableBufferAvailablityListener() {
    }

    public void notifyDataAvailable() {
        this.numNotifications.getAndIncrement();
    }

    public long getNumNotifications() {
        return this.numNotifications.get();
    }

    public boolean notifyPriorityEvent(BufferConsumer eventBufferConsumer) {
        this.numPriorityEvents.getAndIncrement();
        return this.consumePriorityEvents.get();
    }

    public long getNumPriorityEvents() {
        return this.numPriorityEvents.get();
    }

    public void consumePriorityEvents() {
        this.consumePriorityEvents.set(true);
    }

    public void resetNotificationCounters() {
        this.numNotifications.set(0L);
    }

    void awaitNotifications(long awaitedNumNotifications, long timeoutMillis) throws InterruptedException {
        long deadline = System.currentTimeMillis() + timeoutMillis;
        while (this.numNotifications.get() < awaitedNumNotifications && System.currentTimeMillis() < deadline) {
            Thread.sleep(1L);
        }
    }
}

