/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.util;

import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.util.TestProducerSource;
import org.apache.flink.util.Preconditions;

public class TestPartitionProducer
implements Callable<Boolean> {
    public static final int MAX_SLEEP_TIME_MS = 20;
    private final ResultPartition partition;
    private final boolean isSlowProducer;
    private final TestProducerSource source;
    private final Random random;

    public TestPartitionProducer(ResultPartition partition, boolean isSlowProducer, TestProducerSource source) {
        this.partition = (ResultPartition)Preconditions.checkNotNull((Object)partition);
        this.isSlowProducer = isSlowProducer;
        this.random = isSlowProducer ? new Random() : null;
        this.source = (TestProducerSource)Preconditions.checkNotNull((Object)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        boolean success = false;
        try {
            TestProducerSource.BufferConsumerAndChannel consumerAndChannel;
            while ((consumerAndChannel = this.source.getNextBufferConsumer()) != null) {
                this.partition.addBufferConsumer(consumerAndChannel.getBufferConsumer(), consumerAndChannel.getTargetChannel());
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (!this.isSlowProducer) continue;
                Thread.sleep(this.random.nextInt(21));
            }
            this.partition.finish();
            success = true;
            Boolean bl = true;
            return bl;
        }
        finally {
            if (!success) {
                this.partition.release();
            }
        }
    }
}

