/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.TestingComponentMainThreadExecutor;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmanager.scheduler.SchedulerTestBase;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.ExceptionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class SchedulerIsolatedTasksTest
extends SchedulerTestBase {
    @ClassRule
    public static final TestingComponentMainThreadExecutor.Resource TESTING_COMPONENT_MAIN_THREAD_EXECUTOR_RESOURCE = new TestingComponentMainThreadExecutor.Resource();

    @Override
    protected ComponentMainThreadExecutor getComponentMainThreadExecutor() {
        return TESTING_COMPONENT_MAIN_THREAD_EXECUTOR_RESOURCE.getComponentMainThreadTestExecutor().getMainThreadExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testScheduleQueueing() throws Exception {
        Object object;
        int numInstances = 50;
        int numSlotsPerInstance = 3;
        int numTasksToSchedule = 2000;
        for (int i = 0; i < 50; ++i) {
            this.testingSlotProvider.addTaskManager((int)(Math.random() * 3.0) + 1);
        }
        int totalSlots = this.testingSlotProvider.getNumberOfAvailableSlots();
        ArrayList<CompletableFuture> allAllocatedSlots = new ArrayList<CompletableFuture>();
        HashSet toRelease = new HashSet();
        AtomicBoolean errored = new AtomicBoolean(false);
        for (int i = 0; i < 2000; ++i) {
            CompletableFuture future = this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution()), SlotProfile.noRequirements(), TestingUtils.infiniteTime());
            future.thenAcceptAsync(slot -> {
                Set set = toRelease;
                synchronized (set) {
                    toRelease.add(slot);
                    toRelease.notifyAll();
                }
            }, (Executor)TestingUtils.defaultExecutionContext());
            allAllocatedSlots.add(future);
        }
        try {
            for (int recycled = 0; recycled < 2000; ++recycled) {
                object = toRelease;
                synchronized (object) {
                    while (toRelease.isEmpty()) {
                        toRelease.wait();
                    }
                    Iterator iter = toRelease.iterator();
                    LogicalSlot next = (LogicalSlot)iter.next();
                    iter.remove();
                    this.runInMainThreadExecutor(() -> ((LogicalSlot)next).releaseSlot());
                    continue;
                }
            }
        }
        catch (Throwable t) {
            errored.set(true);
        }
        Assert.assertFalse((String)"The slot releasing thread caused an error.", (boolean)errored.get());
        ArrayList slotsAfter = new ArrayList();
        object = allAllocatedSlots.iterator();
        while (true) {
            if (!object.hasNext()) {
                Assert.assertTrue((boolean)SchedulerIsolatedTasksTest.areAllDistinct(slotsAfter.toArray()));
                Assert.assertEquals((String)"All slots should be available.", (long)totalSlots, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
                return;
            }
            CompletableFuture future = (CompletableFuture)object.next();
            slotsAfter.add(future.get());
        }
    }

    @Test
    public void testScheduleWithDyingInstances() throws Exception {
        TaskManagerLocation taskManagerLocation1 = this.testingSlotProvider.addTaskManager(2);
        TaskManagerLocation taskManagerLocation2 = this.testingSlotProvider.addTaskManager(2);
        TaskManagerLocation taskManagerLocation3 = this.testingSlotProvider.addTaskManager(1);
        ArrayList slots = new ArrayList();
        slots.add(this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution()), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get());
        slots.add(this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution()), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get());
        slots.add(this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution()), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get());
        slots.add(this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution()), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get());
        slots.add(this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution()), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get());
        this.testingSlotProvider.releaseTaskManager(taskManagerLocation2.getResourceID());
        for (LogicalSlot slot : slots) {
            if (slot.getTaskManagerLocation().getResourceID().equals((Object)taskManagerLocation2.getResourceID())) {
                Assert.assertFalse((boolean)slot.isAlive());
            } else {
                Assert.assertTrue((boolean)slot.isAlive());
            }
            this.runInMainThreadExecutor(() -> ((LogicalSlot)slot).releaseSlot());
        }
        Assert.assertEquals((long)3L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        this.testingSlotProvider.releaseTaskManager(taskManagerLocation1.getResourceID());
        this.testingSlotProvider.releaseTaskManager(taskManagerLocation3.getResourceID());
        try {
            this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution()), SlotProfile.noRequirements(), Time.milliseconds((long)10L)).get();
            Assert.fail((String)"Scheduler served a slot from a dead instance");
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)ExceptionUtils.stripExecutionException((Throwable)e), (Matcher)Matchers.instanceOf(TimeoutException.class));
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type.");
        }
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
    }

    @Test
    public void testSchedulingLocation() throws Exception {
        int index;
        TaskManagerLocation taskManagerLocation1 = this.testingSlotProvider.addTaskManager(2);
        TaskManagerLocation taskManagerLocation2 = this.testingSlotProvider.addTaskManager(2);
        TaskManagerLocation taskManagerLocation3 = this.testingSlotProvider.addTaskManager(2);
        LogicalSlot s1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(new LocalTaskManagerLocation())), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        ResourceID firstResourceId = s1.getTaskManagerLocation().getResourceID();
        List<TaskManagerLocation> taskManagerLocations = Arrays.asList(taskManagerLocation1, taskManagerLocation2, taskManagerLocation3);
        for (index = 0; index < taskManagerLocations.size() && !Objects.equals(taskManagerLocations.get(index).getResourceID(), firstResourceId); ++index) {
        }
        TaskManagerLocation first = taskManagerLocations.get(index);
        TaskManagerLocation second = taskManagerLocations.get((index + 1) % taskManagerLocations.size());
        TaskManagerLocation third = taskManagerLocations.get((index + 2) % taskManagerLocations.size());
        LogicalSlot s2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(s1.getTaskManagerLocation())), SchedulerIsolatedTasksTest.slotProfileForLocation(s1.getTaskManagerLocation()), TestingUtils.infiniteTime()).get();
        Assert.assertEquals((Object)first.getResourceID(), (Object)s2.getTaskManagerLocation().getResourceID());
        LogicalSlot s3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(first, second)), SchedulerIsolatedTasksTest.slotProfileForLocation(first, second), TestingUtils.infiniteTime()).get();
        Assert.assertEquals((Object)second.getResourceID(), (Object)s3.getTaskManagerLocation().getResourceID());
        LogicalSlot s4 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(first, third)), SchedulerIsolatedTasksTest.slotProfileForLocation(first, third), TestingUtils.infiniteTime()).get();
        LogicalSlot s5 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(first, third)), SchedulerIsolatedTasksTest.slotProfileForLocation(first, third), TestingUtils.infiniteTime()).get();
        Assert.assertEquals((Object)third.getResourceID(), (Object)s4.getTaskManagerLocation().getResourceID());
        Assert.assertEquals((Object)third.getResourceID(), (Object)s5.getTaskManagerLocation().getResourceID());
        LogicalSlot s6 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(first, third)), SchedulerIsolatedTasksTest.slotProfileForLocation(first, third), TestingUtils.infiniteTime()).get();
        Assert.assertEquals((Object)second.getResourceID(), (Object)s6.getTaskManagerLocation().getResourceID());
        this.runInMainThreadExecutor(() -> ((LogicalSlot)s2).releaseSlot());
        this.runInMainThreadExecutor(() -> ((LogicalSlot)s6).releaseSlot());
        LogicalSlot s7 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(first, third)), SchedulerIsolatedTasksTest.slotProfileForLocation(first, third), TestingUtils.infiniteTime()).get();
        Assert.assertEquals((Object)first.getResourceID(), (Object)s7.getTaskManagerLocation().getResourceID());
        Assert.assertEquals((long)1L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
        Assert.assertTrue((1 == this.testingSlotProvider.getNumberOfNonLocalizedAssignments() || 1 == this.testingSlotProvider.getNumberOfHostLocalizedAssignments() ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
    }

    @Test
    public void testNewPhysicalSlotAllocation() {
        ResourceProfile taskResourceProfile = ResourceProfile.fromResources((double)0.5, (int)250);
        ResourceProfile physicalSlotResourceProfile = ResourceProfile.fromResources((double)1.0, (int)300);
        this.testingSlotProvider.allocateSlot(new SlotRequestId(), new ScheduledUnit(new JobVertexID(), null, null), SlotProfile.priorAllocation((ResourceProfile)taskResourceProfile, (ResourceProfile)physicalSlotResourceProfile, Collections.emptyList(), Collections.emptyList(), Collections.emptySet()), TestingUtils.infiniteTime());
        Assert.assertEquals((Object)physicalSlotResourceProfile, (Object)this.testingSlotProvider.getSlotPool().getLastRequestedSlotResourceProfile());
    }

    private static SlotProfile slotProfileForLocation(TaskManagerLocation ... location) {
        return SlotProfile.preferredLocality((ResourceProfile)ResourceProfile.UNKNOWN, Arrays.asList(location));
    }

    private static boolean areAllDistinct(Object ... obj) {
        if (obj == null) {
            return true;
        }
        HashSet set = new HashSet();
        Collections.addAll(set, obj);
        return set.size() == obj.length;
    }
}

