/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmaster.JobMaster;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.jobmaster.utils.JobMasterBuilder;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.BackPressureStatsTracker;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.TestingRpcServiceResource;
import org.apache.flink.runtime.scheduler.SchedulerNG;
import org.apache.flink.runtime.scheduler.SchedulerNGFactory;
import org.apache.flink.runtime.scheduler.TestingSchedulerNG;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.testutils.SystemExitTrackingSecurityManager;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.slf4j.Logger;

public class JobMasterSchedulerTest
extends TestLogger {
    @ClassRule
    public static final TestingRpcServiceResource TESTING_RPC_SERVICE_RESOURCE = new TestingRpcServiceResource();
    private final Duration testingTimeout = Duration.ofSeconds(10L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIfStartSchedulingFailsJobMasterFailsFatally() throws Exception {
        SystemExitTrackingSecurityManager trackingSecurityManager = new SystemExitTrackingSecurityManager();
        System.setSecurityManager(trackingSecurityManager);
        FailingSchedulerFactory schedulerFactory = new FailingSchedulerFactory();
        JobMaster jobMaster = new JobMasterBuilder(new JobGraph(new JobVertex[0]), (RpcService)TESTING_RPC_SERVICE_RESOURCE.getTestingRpcService()).withSchedulerNGFactory(schedulerFactory).createJobMaster();
        CompletableFuture startFuture = jobMaster.start(JobMasterId.generate());
        try {
            startFuture.join();
            Assert.assertThat((Object)trackingSecurityManager.getSystemExitFuture().join(), (Matcher)CoreMatchers.is((Object)-17));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)Time.milliseconds((long)this.testingTimeout.toMillis()));
            System.setSecurityManager(null);
        }
    }

    private static final class FailingSchedulerFactory
    implements SchedulerNGFactory {
        private FailingSchedulerFactory() {
        }

        public SchedulerNG createInstance(Logger log, JobGraph jobGraph, BackPressureStatsTracker backPressureStatsTracker, Executor ioExecutor, Configuration jobMasterConfiguration, SlotProvider slotProvider, ScheduledExecutorService futureExecutor, ClassLoader userCodeLoader, CheckpointRecoveryFactory checkpointRecoveryFactory, Time rpcTimeout, BlobWriter blobWriter, JobManagerJobMetricGroup jobManagerJobMetricGroup, Time slotRequestTimeout, ShuffleMaster<?> shuffleMaster, JobMasterPartitionTracker partitionTracker) throws Exception {
            return TestingSchedulerNG.newBuilder().setStartSchedulingRunnable(() -> {
                throw new FlinkRuntimeException("Could not start scheduling.");
            }).build();
        }
    }
}

