/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobmaster.JobManagerRunner;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobNotFinishedException;

public class TestingJobManagerRunner
implements JobManagerRunner {
    private final JobID jobId;
    private final boolean blockingTermination;
    private final CompletableFuture<ArchivedExecutionGraph> resultFuture;
    private final CompletableFuture<JobMasterGateway> jobMasterGatewayFuture;
    private final CompletableFuture<Void> terminationFuture;
    private final OneShotLatch closeAsyncLatch = new OneShotLatch();

    public TestingJobManagerRunner(JobID jobId) {
        this(jobId, false);
    }

    public TestingJobManagerRunner(JobID jobId, boolean blockingTermination) {
        this.jobId = jobId;
        this.blockingTermination = blockingTermination;
        this.resultFuture = new CompletableFuture();
        this.jobMasterGatewayFuture = new CompletableFuture();
        this.terminationFuture = new CompletableFuture();
        this.terminationFuture.whenComplete((ignored, ignoredThrowable) -> this.resultFuture.completeExceptionally((Throwable)new JobNotFinishedException(jobId)));
    }

    public void start() throws Exception {
    }

    public CompletableFuture<JobMasterGateway> getJobMasterGateway() {
        return this.jobMasterGatewayFuture;
    }

    public CompletableFuture<ArchivedExecutionGraph> getResultFuture() {
        return this.resultFuture;
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public CompletableFuture<Void> closeAsync() {
        this.closeAsyncLatch.trigger();
        if (!this.blockingTermination) {
            this.terminationFuture.complete(null);
        }
        return this.terminationFuture;
    }

    public void completeResultFuture(ArchivedExecutionGraph archivedExecutionGraph) {
        this.resultFuture.complete(archivedExecutionGraph);
    }

    public void completeResultFutureExceptionally(Exception e) {
        this.resultFuture.completeExceptionally(e);
    }

    public void completeTerminationFuture() {
        this.terminationFuture.complete(null);
    }

    public void waitUntilCloseAsyncIsBeingCalled() throws InterruptedException {
        this.closeAsyncLatch.await();
    }

    public CompletableFuture<Void> getTerminationFuture() {
        return this.terminationFuture;
    }
}

