/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.utils;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.dispatcher.SchedulerNGFactoryFactory;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.io.network.partition.NoOpJobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.PartitionTrackerFactory;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.OnCompletionActions;
import org.apache.flink.runtime.jobmaster.JobManagerSharedServices;
import org.apache.flink.runtime.jobmaster.JobMaster;
import org.apache.flink.runtime.jobmaster.JobMasterConfiguration;
import org.apache.flink.runtime.jobmaster.TestingJobManagerSharedServicesBuilder;
import org.apache.flink.runtime.jobmaster.factories.JobManagerJobMetricGroupFactory;
import org.apache.flink.runtime.jobmaster.factories.UnregisteredJobManagerJobMetricGroupFactory;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultSchedulerFactory;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultSlotPoolFactory;
import org.apache.flink.runtime.jobmaster.slotpool.SchedulerFactory;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolFactory;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.scheduler.SchedulerNGFactory;
import org.apache.flink.runtime.shuffle.NettyShuffleMaster;
import org.apache.flink.runtime.shuffle.ShuffleMaster;

public class JobMasterBuilder {
    private static final long heartbeatInterval = 1000L;
    private static final long heartbeatTimeout = 5000000L;
    private static final HeartbeatServices DEFAULT_HEARTBEAT_SERVICES = new HeartbeatServices(1000L, 5000000L);
    private Configuration configuration = new Configuration();
    private final JobGraph jobGraph;
    private final RpcService rpcService;
    private HighAvailabilityServices highAvailabilityServices;
    private JobManagerSharedServices jobManagerSharedServices = new TestingJobManagerSharedServicesBuilder().build();
    private HeartbeatServices heartbeatServices = DEFAULT_HEARTBEAT_SERVICES;
    private SlotPoolFactory slotPoolFactory = null;
    private SchedulerFactory schedulerFactory = null;
    private OnCompletionActions onCompletionActions = new TestingOnCompletionActions();
    private ShuffleMaster<?> shuffleMaster = NettyShuffleMaster.INSTANCE;
    private PartitionTrackerFactory partitionTrackerFactory = NoOpJobMasterPartitionTracker.FACTORY;
    private ResourceID jmResourceId = ResourceID.generate();
    @Nullable
    private SchedulerNGFactory schedulerNGFactory = null;
    private FatalErrorHandler fatalErrorHandler = error -> {};

    public JobMasterBuilder(JobGraph jobGraph, RpcService rpcService) {
        TestingHighAvailabilityServices testingHighAvailabilityServices = new TestingHighAvailabilityServices();
        testingHighAvailabilityServices.setCheckpointRecoveryFactory((CheckpointRecoveryFactory)new StandaloneCheckpointRecoveryFactory());
        SettableLeaderRetrievalService rmLeaderRetrievalService = new SettableLeaderRetrievalService(null, null);
        testingHighAvailabilityServices.setResourceManagerLeaderRetriever(rmLeaderRetrievalService);
        this.highAvailabilityServices = testingHighAvailabilityServices;
        this.jobGraph = jobGraph;
        this.rpcService = rpcService;
    }

    public JobMasterBuilder withConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public JobMasterBuilder withHighAvailabilityServices(HighAvailabilityServices highAvailabilityServices) {
        this.highAvailabilityServices = highAvailabilityServices;
        return this;
    }

    public JobMasterBuilder withJobManagerSharedServices(JobManagerSharedServices jobManagerSharedServices) {
        this.jobManagerSharedServices = jobManagerSharedServices;
        return this;
    }

    public JobMasterBuilder withHeartbeatServices(HeartbeatServices heartbeatServices) {
        this.heartbeatServices = heartbeatServices;
        return this;
    }

    public JobMasterBuilder withSlotPoolFactory(SlotPoolFactory slotPoolFactory) {
        this.slotPoolFactory = slotPoolFactory;
        return this;
    }

    public JobMasterBuilder withFatalErrorHandler(FatalErrorHandler fatalErrorHandler) {
        this.fatalErrorHandler = fatalErrorHandler;
        return this;
    }

    public JobMasterBuilder withSchedulerNGFactory(SchedulerFactory schedulerFactory) {
        this.schedulerFactory = schedulerFactory;
        return this;
    }

    public JobMasterBuilder withOnCompletionActions(OnCompletionActions onCompletionActions) {
        this.onCompletionActions = onCompletionActions;
        return this;
    }

    public JobMasterBuilder withResourceId(ResourceID resourceId) {
        this.jmResourceId = resourceId;
        return this;
    }

    public JobMasterBuilder withShuffleMaster(ShuffleMaster<?> shuffleMaster) {
        this.shuffleMaster = shuffleMaster;
        return this;
    }

    public JobMasterBuilder withPartitionTrackerFactory(PartitionTrackerFactory partitionTrackerFactory) {
        this.partitionTrackerFactory = partitionTrackerFactory;
        return this;
    }

    public JobMasterBuilder withSchedulerNGFactory(SchedulerNGFactory schedulerFactory) {
        this.schedulerNGFactory = schedulerFactory;
        return this;
    }

    public JobMaster createJobMaster() throws Exception {
        JobMasterConfiguration jobMasterConfiguration = JobMasterConfiguration.fromConfiguration((Configuration)this.configuration);
        return new JobMaster(this.rpcService, jobMasterConfiguration, this.jmResourceId, this.jobGraph, this.highAvailabilityServices, (SlotPoolFactory)(this.slotPoolFactory != null ? this.slotPoolFactory : DefaultSlotPoolFactory.fromConfiguration((Configuration)this.configuration)), (SchedulerFactory)(this.schedulerFactory != null ? this.schedulerFactory : DefaultSchedulerFactory.fromConfiguration((Configuration)this.configuration)), this.jobManagerSharedServices, this.heartbeatServices, (JobManagerJobMetricGroupFactory)UnregisteredJobManagerJobMetricGroupFactory.INSTANCE, this.onCompletionActions, this.fatalErrorHandler, JobMasterBuilder.class.getClassLoader(), this.schedulerNGFactory != null ? this.schedulerNGFactory : SchedulerNGFactoryFactory.createSchedulerNGFactory((Configuration)this.configuration), this.shuffleMaster, this.partitionTrackerFactory);
    }

    public static final class TestingOnCompletionActions
    implements OnCompletionActions {
        private final CompletableFuture<ArchivedExecutionGraph> jobReachedGloballyTerminalStateFuture = new CompletableFuture();
        private final CompletableFuture<Void> jobFinishedByOtherFuture = new CompletableFuture();
        private final CompletableFuture<Throwable> jobMasterFailedFuture = new CompletableFuture();

        public void jobReachedGloballyTerminalState(ArchivedExecutionGraph executionGraph) {
            this.jobReachedGloballyTerminalStateFuture.complete(executionGraph);
        }

        public void jobFinishedByOther() {
            this.jobFinishedByOtherFuture.complete(null);
        }

        public void jobMasterFailed(Throwable cause) {
            this.jobMasterFailedFuture.complete(cause);
        }

        public CompletableFuture<ArchivedExecutionGraph> getJobReachedGloballyTerminalStateFuture() {
            return this.jobReachedGloballyTerminalStateFuture;
        }

        public CompletableFuture<ArchivedExecutionGraph> getJobFinishedByOtherFuture() {
            return this.jobReachedGloballyTerminalStateFuture;
        }

        public CompletableFuture<ArchivedExecutionGraph> getJobMasterFailedFuture() {
            return this.jobReachedGloballyTerminalStateFuture;
        }
    }
}

