/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import org.apache.flink.runtime.memory.MemoryManager;

public class MemoryManagerBuilder {
    private static final long DEFAULT_MEMORY_SIZE = 0x100000L;
    private long memorySize = 0x100000L;
    private int pageSize = 32768;

    private MemoryManagerBuilder() {
    }

    public MemoryManagerBuilder setMemorySize(long memorySize) {
        this.memorySize = memorySize;
        return this;
    }

    public MemoryManagerBuilder setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public MemoryManager build() {
        return new MemoryManager(this.memorySize, this.pageSize, 10);
    }

    public static MemoryManagerBuilder newBuilder() {
        return new MemoryManagerBuilder();
    }
}

