/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import org.apache.flink.runtime.memory.MemoryReservationException;
import org.apache.flink.runtime.memory.UnsafeMemoryBudget;
import org.apache.flink.util.JavaGcCleanerWrapper;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class UnsafeMemoryBudgetTest
extends TestLogger {
    static final int MAX_SLEEPS_VERIFY_EMPTY_FOR_TESTS = 10;

    @Test
    public void testGetTotalMemory() {
        UnsafeMemoryBudget budget = UnsafeMemoryBudgetTest.createUnsafeMemoryBudget();
        Assert.assertThat((Object)budget.getTotalMemorySize(), (Matcher)CoreMatchers.is((Object)100L));
    }

    @Test
    public void testReserveMemory() throws MemoryReservationException {
        UnsafeMemoryBudget budget = UnsafeMemoryBudgetTest.createUnsafeMemoryBudget();
        budget.reserveMemory(50L);
        Assert.assertThat((Object)budget.getAvailableMemorySize(), (Matcher)CoreMatchers.is((Object)50L));
    }

    @Test(expected=MemoryReservationException.class)
    public void testReserveMemoryOverLimitFails() throws MemoryReservationException {
        UnsafeMemoryBudget budget = UnsafeMemoryBudgetTest.createUnsafeMemoryBudget();
        budget.reserveMemory(120L);
    }

    @Test
    public void testReleaseMemory() throws MemoryReservationException {
        UnsafeMemoryBudget budget = UnsafeMemoryBudgetTest.createUnsafeMemoryBudget();
        budget.reserveMemory(50L);
        budget.releaseMemory(30L);
        Assert.assertThat((Object)budget.getAvailableMemorySize(), (Matcher)CoreMatchers.is((Object)80L));
    }

    @Test(expected=IllegalStateException.class)
    public void testReleaseMemoryMoreThanReservedFails() throws MemoryReservationException {
        UnsafeMemoryBudget budget = UnsafeMemoryBudgetTest.createUnsafeMemoryBudget();
        budget.reserveMemory(50L);
        budget.releaseMemory(70L);
    }

    @Test(expected=MemoryReservationException.class)
    public void testReservationFailsIfOwnerNotGced() throws MemoryReservationException {
        UnsafeMemoryBudget budget = UnsafeMemoryBudgetTest.createUnsafeMemoryBudget();
        Object memoryOwner = new Object();
        budget.reserveMemory(50L);
        JavaGcCleanerWrapper.createCleaner((Object)memoryOwner, () -> budget.releaseMemory(50L));
        budget.reserveMemory(60L);
        this.log.info(memoryOwner.toString());
    }

    @Test
    public void testReservationSuccessIfOwnerGced() throws MemoryReservationException {
        UnsafeMemoryBudget budget = UnsafeMemoryBudgetTest.createUnsafeMemoryBudget();
        budget.reserveMemory(50L);
        JavaGcCleanerWrapper.createCleaner((Object)new Object(), () -> budget.releaseMemory(50L));
        budget.reserveMemory(60L);
        Assert.assertThat((Object)budget.getAvailableMemorySize(), (Matcher)CoreMatchers.is((Object)40L));
    }

    private static UnsafeMemoryBudget createUnsafeMemoryBudget() {
        return new UnsafeMemoryBudget(100L, 10);
    }
}

