/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.core.testutils.BlockerSync;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.NoOpMetricRegistry;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.FrontMetricGroup;
import org.apache.flink.runtime.metrics.groups.GenericMetricGroup;
import org.apache.flink.runtime.metrics.groups.ProcessMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.runtime.metrics.util.TestReporter;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;

public class AbstractMetricGroupTest
extends TestLogger {
    private static final CharacterFilter FILTER_C = new CharacterFilter(){

        public String filterCharacters(String input) {
            return input.replace("C", "X");
        }
    };
    private static final CharacterFilter FILTER_B = new CharacterFilter(){

        public String filterCharacters(String input) {
            return input.replace("B", "X");
        }
    };

    @Test
    public void testGetAllVariables() throws Exception {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        AbstractMetricGroup group = new AbstractMetricGroup<AbstractMetricGroup<?>>((MetricRegistry)registry, new String[0], null){

            protected QueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
                return null;
            }

            protected String getGroupName(CharacterFilter filter) {
                return "";
            }
        };
        Assert.assertTrue((boolean)group.getAllVariables().isEmpty());
        registry.shutdown().get();
    }

    @Test
    public void testGetAllVariablesWithOutExclusions() {
        MetricRegistry registry = NoOpMetricRegistry.INSTANCE;
        ProcessMetricGroup group = new ProcessMetricGroup(registry, "host");
        MatcherAssert.assertThat((Object)group.getAllVariables(), (Matcher)IsMapContaining.hasKey((Object)ScopeFormat.SCOPE_HOST));
    }

    @Test
    public void testGetAllVariablesWithExclusions() {
        MetricRegistry registry = NoOpMetricRegistry.INSTANCE;
        ProcessMetricGroup group = new ProcessMetricGroup(registry, "host");
        Assert.assertEquals((long)group.getAllVariables(-1, Collections.singleton(ScopeFormat.SCOPE_HOST)).size(), (long)0L);
    }

    @Test
    public void testGetAllVariablesWithExclusionsForReporters() {
        TestMetricRegistry registry = new TestMetricRegistry();
        registry.setNumReporters(2);
        GenericMetricGroup group = new GenericMetricGroup(registry, null, "test"){

            protected void putVariables(Map<String, String> variables) {
                variables.put("k1", "v1");
                variables.put("k2", "v2");
            }
        };
        group.getAllVariables(-1, Collections.emptySet());
        MatcherAssert.assertThat((Object)group.getAllVariables(0, Collections.singleton("k1")), (Matcher)IsNot.not((Matcher)IsMapContaining.hasKey((Object)"k1")));
        MatcherAssert.assertThat((Object)group.getAllVariables(0, Collections.singleton("k1")), (Matcher)IsMapContaining.hasKey((Object)"k2"));
        MatcherAssert.assertThat((Object)group.getAllVariables(1, Collections.singleton("k2")), (Matcher)IsMapContaining.hasKey((Object)"k1"));
        MatcherAssert.assertThat((Object)group.getAllVariables(1, Collections.singleton("k2")), (Matcher)IsNot.not((Matcher)IsMapContaining.hasKey((Object)"k2")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScopeCachingForMultipleReporters() throws Exception {
        Configuration config = new Configuration();
        config.setString(MetricOptions.SCOPE_NAMING_TM, "A.B.C.D");
        MetricConfig metricConfig1 = new MetricConfig();
        metricConfig1.setProperty("scope.delimiter", "-");
        MetricConfig metricConfig2 = new MetricConfig();
        metricConfig2.setProperty("scope.delimiter", "!");
        config.setString("metrics.reporter.test1.class", TestReporter1.class.getName());
        config.setString("metrics.reporter.test1.scope.delimiter", "-");
        config.setString("metrics.reporter.test2.class", TestReporter2.class.getName());
        config.setString("metrics.reporter.test2.scope.delimiter", "!");
        MetricRegistryImpl testRegistry = new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration((Configuration)config), Arrays.asList(ReporterSetup.forReporter((String)"test1", (MetricConfig)metricConfig1, (MetricReporter)new TestReporter1()), ReporterSetup.forReporter((String)"test2", (MetricConfig)metricConfig2, (MetricReporter)new TestReporter2())));
        try {
            TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup((MetricRegistry)testRegistry, "host", "id");
            tmGroup.counter("1");
            Assert.assertEquals((String)"Reporters were not properly instantiated", (long)2L, (long)testRegistry.getReporters().size());
            for (MetricReporter reporter : testRegistry.getReporters()) {
                ScopeCheckingTestReporter typedReporter = (ScopeCheckingTestReporter)reporter;
                if (typedReporter.failureCause == null) continue;
                throw typedReporter.failureCause;
            }
        }
        finally {
            testRegistry.shutdown().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogicalScopeCachingForMultipleReporters() throws Exception {
        MetricRegistryImpl testRegistry = new MetricRegistryImpl(MetricRegistryConfiguration.defaultMetricRegistryConfiguration(), Arrays.asList(ReporterSetup.forReporter((String)"test1", (MetricReporter)new LogicalScopeReporter1()), ReporterSetup.forReporter((String)"test2", (MetricReporter)new LogicalScopeReporter2())));
        try {
            MetricGroup tmGroup = new TaskManagerMetricGroup((MetricRegistry)testRegistry, "host", "id").addGroup("B").addGroup("C");
            tmGroup.counter("1");
            Assert.assertEquals((String)"Reporters were not properly instantiated", (long)2L, (long)testRegistry.getReporters().size());
            for (MetricReporter reporter : testRegistry.getReporters()) {
                ScopeCheckingTestReporter typedReporter = (ScopeCheckingTestReporter)reporter;
                if (typedReporter.failureCause == null) continue;
                throw typedReporter.failureCause;
            }
        }
        finally {
            testRegistry.shutdown().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScopeGenerationWithoutReporters() throws Exception {
        Configuration config = new Configuration();
        config.setString(MetricOptions.SCOPE_NAMING_TM, "A.B.C.D");
        MetricRegistryImpl testRegistry = new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration((Configuration)config));
        try {
            TaskManagerMetricGroup group = new TaskManagerMetricGroup((MetricRegistry)testRegistry, "host", "id");
            Assert.assertEquals((String)"MetricReporters list should be empty", (long)0L, (long)testRegistry.getReporters().size());
            Assert.assertEquals((Object)"A.B.X.D.1", (Object)group.getMetricIdentifier("1", FILTER_C));
            Assert.assertEquals((Object)"A.X.C.D.1", (Object)group.getMetricIdentifier("1", FILTER_B));
            Assert.assertEquals((Object)"A.X.C.D.1", (Object)group.getMetricIdentifier("1", FILTER_B, -1, '.'));
            Assert.assertEquals((Object)"A.X.C.D.1", (Object)group.getMetricIdentifier("1", FILTER_B, 2, '.'));
        }
        finally {
            testRegistry.shutdown().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAllVariablesDoesNotDeadlock() throws InterruptedException {
        TestMetricRegistry registry = new TestMetricRegistry();
        GenericMetricGroup parent = new GenericMetricGroup((MetricRegistry)registry, (AbstractMetricGroup)UnregisteredMetricGroups.createUnregisteredTaskManagerMetricGroup(), "parent");
        MetricGroup child = parent.addGroup("child");
        Thread parentRegisteringThread = new Thread(() -> AbstractMetricGroupTest.lambda$testGetAllVariablesDoesNotDeadlock$0((MetricGroup)parent));
        Thread childRegisteringThread = new Thread(() -> child.counter("child_counter"));
        BlockerSync parentSync = new BlockerSync();
        BlockerSync childSync = new BlockerSync();
        try {
            registry.setOnRegistrationAction(() -> ((BlockerSync)childSync).blockNonInterruptible());
            childRegisteringThread.start();
            childSync.awaitBlocker();
            registry.setOnRegistrationAction(() -> ((BlockerSync)parentSync).blockNonInterruptible());
            parentRegisteringThread.start();
            parentSync.awaitBlocker();
            childSync.releaseBlocker();
            childRegisteringThread.join(10000L);
            parentSync.releaseBlocker();
            parentRegisteringThread.join();
        }
        finally {
            parentSync.releaseBlocker();
            childSync.releaseBlocker();
            parentRegisteringThread.join();
            childRegisteringThread.join();
        }
    }

    private static /* synthetic */ void lambda$testGetAllVariablesDoesNotDeadlock$0(MetricGroup parent) {
        parent.counter("parent_counter");
    }

    private static final class TestMetricRegistry
    implements MetricRegistry {
        private Runnable onRegistrationAction;
        private int numReporters = 0;

        private TestMetricRegistry() {
        }

        void setNumReporters(int numReporters) {
            this.numReporters = numReporters;
        }

        void setOnRegistrationAction(Runnable onRegistrationAction) {
            this.onRegistrationAction = onRegistrationAction;
        }

        public char getDelimiter() {
            return '\u0000';
        }

        public int getNumberReporters() {
            return this.numReporters;
        }

        public void register(Metric metric, String metricName, AbstractMetricGroup group) {
            this.onRegistrationAction.run();
            group.getAllVariables();
        }

        public void unregister(Metric metric, String metricName, AbstractMetricGroup group) {
        }

        public ScopeFormats getScopeFormats() {
            return null;
        }
    }

    public static final class LogicalScopeReporter2
    extends ScopeCheckingTestReporter {
        @Override
        public String filterCharacters(String input) {
            return FILTER_C.filterCharacters(input);
        }

        @Override
        public void checkScopes(Metric metric, String metricName, MetricGroup group) {
            String logicalScope = ((FrontMetricGroup)group).getLogicalScope((CharacterFilter)this, ',');
            Assert.assertEquals((Object)"taskmanager,B,X", (Object)logicalScope);
        }
    }

    public static final class LogicalScopeReporter1
    extends ScopeCheckingTestReporter {
        @Override
        public String filterCharacters(String input) {
            return FILTER_B.filterCharacters(input);
        }

        @Override
        public void checkScopes(Metric metric, String metricName, MetricGroup group) {
            String logicalScope = ((FrontMetricGroup)group).getLogicalScope((CharacterFilter)this, '-');
            Assert.assertEquals((Object)"taskmanager-X-C", (Object)logicalScope);
        }
    }

    public static class TestReporter2
    extends ScopeCheckingTestReporter {
        @Override
        public String filterCharacters(String input) {
            return FILTER_C.filterCharacters(input);
        }

        @Override
        public void checkScopes(Metric metric, String metricName, MetricGroup group) {
            Assert.assertEquals((Object)"A!B!X!D!1", (Object)group.getMetricIdentifier(metricName, (CharacterFilter)this));
            Assert.assertEquals((Object)"A!B!X!D!1", (Object)group.getMetricIdentifier(metricName));
            Assert.assertEquals((Object)"A!B!X!D!1", (Object)group.getMetricIdentifier(metricName, FILTER_C));
            Assert.assertEquals((Object)"A!B!X!D!3", (Object)group.getMetricIdentifier(metricName, new CharacterFilter(){

                public String filterCharacters(String input) {
                    return input.replace("A", "X").replace("1", "3");
                }
            }));
        }
    }

    public static class TestReporter1
    extends ScopeCheckingTestReporter {
        @Override
        public String filterCharacters(String input) {
            return FILTER_B.filterCharacters(input);
        }

        @Override
        public void checkScopes(Metric metric, String metricName, MetricGroup group) {
            Assert.assertEquals((Object)"A-B-C-D-1", (Object)group.getMetricIdentifier(metricName));
            Assert.assertEquals((Object)"A-B-C-D-1", (Object)group.getMetricIdentifier(metricName, FILTER_C));
            Assert.assertEquals((Object)"A-B-C-D-1", (Object)group.getMetricIdentifier(metricName, (CharacterFilter)this));
            Assert.assertEquals((Object)"A-B-C-D-4", (Object)group.getMetricIdentifier(metricName, new CharacterFilter(){

                public String filterCharacters(String input) {
                    return input.replace("B", "X").replace("1", "4");
                }
            }));
        }
    }

    private static abstract class ScopeCheckingTestReporter
    extends TestReporter {
        protected Exception failureCause;

        private ScopeCheckingTestReporter() {
        }

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            block2: {
                try {
                    this.checkScopes(metric, metricName, group);
                }
                catch (Exception e) {
                    if (this.failureCause != null) break block2;
                    this.failureCause = e;
                }
            }
        }

        public abstract void checkScopes(Metric var1, String var2, MetricGroup var3);
    }
}

