/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.util;

import akka.actor.ActorSystem;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.metrics.util.InterceptingOperatorMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcService;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricUtilsTest
extends TestLogger {
    private static final Logger LOG = LoggerFactory.getLogger(MetricUtilsTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartMetricActorSystemRespectsThreadPriority() throws Exception {
        Configuration configuration = new Configuration();
        int expectedThreadPriority = 3;
        configuration.setInteger(MetricOptions.QUERY_SERVICE_THREAD_PRIORITY, 3);
        RpcService rpcService = MetricUtils.startRemoteMetricsRpcService((Configuration)configuration, (String)"localhost");
        Assert.assertThat((Object)rpcService, (Matcher)CoreMatchers.instanceOf(AkkaRpcService.class));
        ActorSystem actorSystem = ((AkkaRpcService)rpcService).getActorSystem();
        try {
            int threadPriority = actorSystem.settings().config().getInt("akka.actor.default-dispatcher.thread-priority");
            Assert.assertThat((Object)threadPriority, (Matcher)Matchers.is((Object)3));
        }
        finally {
            AkkaUtils.terminateActorSystem((ActorSystem)actorSystem).get();
        }
    }

    @Test
    public void testNonHeapMetricsCompleteness() {
        InterceptingOperatorMetricGroup nonHeapMetrics = new InterceptingOperatorMetricGroup();
        MetricUtils.instantiateNonHeapMemoryMetrics((MetricGroup)nonHeapMetrics);
        Assert.assertNotNull((Object)nonHeapMetrics.get("Used"));
        Assert.assertNotNull((Object)nonHeapMetrics.get("Committed"));
        Assert.assertNotNull((Object)nonHeapMetrics.get("Max"));
    }

    @Test
    public void testHeapMetricsCompleteness() {
        InterceptingOperatorMetricGroup heapMetrics = new InterceptingOperatorMetricGroup();
        MetricUtils.instantiateHeapMemoryMetrics((MetricGroup)heapMetrics);
        Assert.assertNotNull((Object)heapMetrics.get("Used"));
        Assert.assertNotNull((Object)heapMetrics.get("Committed"));
        Assert.assertNotNull((Object)heapMetrics.get("Max"));
    }

    @Test
    public void testHeapMetrics() throws Exception {
        InterceptingOperatorMetricGroup heapMetrics = new InterceptingOperatorMetricGroup();
        MetricUtils.instantiateHeapMemoryMetrics((MetricGroup)heapMetrics);
        Gauge used = (Gauge)heapMetrics.get("Used");
        long usedHeapInitially = (Long)used.getValue();
        for (int x = 0; x < 10; ++x) {
            byte[] array = new byte[0x800000];
            long usedHeapAfterAllocation = (Long)used.getValue();
            if (usedHeapInitially != usedHeapAfterAllocation) {
                return;
            }
            Thread.sleep(50L);
        }
        Assert.fail((String)"Heap usage metric never changed it's value.");
    }
}

