/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.util.SerializedValue;

final class TestEventSender
implements BiFunction<SerializedValue<OperatorEvent>, Integer, CompletableFuture<Acknowledge>> {
    final ArrayList<EventWithSubtask> events = new ArrayList();
    @Nullable
    private final Throwable failureCause;

    TestEventSender() {
        this(null);
    }

    TestEventSender(@Nullable Throwable failureCause) {
        this.failureCause = failureCause;
    }

    @Override
    public CompletableFuture<Acknowledge> apply(SerializedValue<OperatorEvent> event, Integer subtask) {
        OperatorEvent deserializedEvent;
        try {
            deserializedEvent = (OperatorEvent)event.deserializeValue(this.getClass().getClassLoader());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        this.events.add(new EventWithSubtask(deserializedEvent, subtask));
        return this.failureCause == null ? CompletableFuture.completedFuture(Acknowledge.get()) : FutureUtils.completedExceptionally((Throwable)this.failureCause);
    }

    static final class EventWithSubtask {
        final OperatorEvent event;
        final int subtask;

        EventWithSubtask(OperatorEvent event, int subtask) {
            this.event = event;
            this.subtask = subtask;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventWithSubtask that = (EventWithSubtask)o;
            return this.subtask == that.subtask && this.event.equals(that.event);
        }

        public int hashCode() {
            return Objects.hash(this.event, this.subtask);
        }

        public String toString() {
            return this.event + " => subtask " + this.subtask;
        }
    }
}

