/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingResourceActions;

public class TestingResourceActionsBuilder {
    private BiConsumer<InstanceID, Exception> releaseResourceConsumer = (ignoredA, ignoredB) -> {};
    private Function<WorkerResourceSpec, Boolean> allocateResourceFunction = ignored -> true;
    private Consumer<Tuple3<JobID, AllocationID, Exception>> notifyAllocationFailureConsumer = ignored -> {};

    public TestingResourceActionsBuilder setReleaseResourceConsumer(BiConsumer<InstanceID, Exception> releaseResourceConsumer) {
        this.releaseResourceConsumer = releaseResourceConsumer;
        return this;
    }

    public TestingResourceActionsBuilder setAllocateResourceFunction(Function<WorkerResourceSpec, Boolean> allocateResourceFunction) {
        this.allocateResourceFunction = allocateResourceFunction;
        return this;
    }

    public TestingResourceActionsBuilder setAllocateResourceConsumer(Consumer<WorkerResourceSpec> allocateResourceConsumer) {
        this.allocateResourceFunction = workerRequest -> {
            allocateResourceConsumer.accept((WorkerResourceSpec)workerRequest);
            return true;
        };
        return this;
    }

    public TestingResourceActionsBuilder setNotifyAllocationFailureConsumer(Consumer<Tuple3<JobID, AllocationID, Exception>> notifyAllocationFailureConsumer) {
        this.notifyAllocationFailureConsumer = notifyAllocationFailureConsumer;
        return this;
    }

    public TestingResourceActions build() {
        return new TestingResourceActions(this.releaseResourceConsumer, this.allocateResourceFunction, this.notifyAllocationFailureConsumer);
    }
}

