/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.job.JobExceptionsHandler;
import org.apache.flink.runtime.rest.handler.legacy.DefaultExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobExceptionsHeaders;
import org.apache.flink.runtime.rest.messages.JobExceptionsInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.JobExceptionsMessageParameters;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.util.EvictingBoundedList;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class JobExceptionsHandlerTest
extends TestLogger {
    @Test
    public void testGetJobExceptionsInfo() throws HandlerRequestException {
        JobExceptionsHandler jobExceptionsHandler = new JobExceptionsHandler(() -> null, TestingUtils.TIMEOUT(), Collections.emptyMap(), (MessageHeaders)JobExceptionsHeaders.getInstance(), (ExecutionGraphCache)new DefaultExecutionGraphCache(TestingUtils.TIMEOUT(), TestingUtils.TIMEOUT()), (Executor)TestingUtils.defaultExecutor());
        int numExceptions = 20;
        AccessExecutionGraph archivedExecutionGraph = JobExceptionsHandlerTest.createAccessExecutionGraph(20);
        JobExceptionsHandlerTest.checkExceptionLimit(jobExceptionsHandler, archivedExecutionGraph, 20, 10);
        JobExceptionsHandlerTest.checkExceptionLimit(jobExceptionsHandler, archivedExecutionGraph, 20, 20);
        JobExceptionsHandlerTest.checkExceptionLimit(jobExceptionsHandler, archivedExecutionGraph, 20, 30);
    }

    private static void checkExceptionLimit(JobExceptionsHandler jobExceptionsHandler, AccessExecutionGraph graph, int maxNumExceptions, int numExpectedException) throws HandlerRequestException {
        HandlerRequest<EmptyRequestBody, JobExceptionsMessageParameters> handlerRequest = JobExceptionsHandlerTest.createRequest(graph.getJobID(), numExpectedException);
        JobExceptionsInfo jobExceptionsInfo = jobExceptionsHandler.handleRequest(handlerRequest, graph);
        int numReportedException = maxNumExceptions >= numExpectedException ? numExpectedException : maxNumExceptions;
        Assert.assertEquals((long)jobExceptionsInfo.getAllExceptions().size(), (long)numReportedException);
    }

    private static AccessExecutionGraph createAccessExecutionGraph(int numTasks) {
        HashMap<JobVertexID, ArchivedExecutionJobVertex> tasks = new HashMap<JobVertexID, ArchivedExecutionJobVertex>();
        for (int i = 0; i < numTasks; ++i) {
            JobVertexID jobVertexId = new JobVertexID();
            tasks.put(jobVertexId, JobExceptionsHandlerTest.createArchivedExecutionJobVertex(jobVertexId));
        }
        return new ArchivedExecutionGraphBuilder().setTasks(tasks).build();
    }

    private static ArchivedExecutionJobVertex createArchivedExecutionJobVertex(JobVertexID jobVertexID) {
        StringifiedAccumulatorResult[] emptyAccumulators = new StringifiedAccumulatorResult[]{};
        long[] timestamps = new long[ExecutionState.values().length];
        ExecutionState expectedState = ExecutionState.RUNNING;
        LocalTaskManagerLocation assignedResourceLocation = new LocalTaskManagerLocation();
        AllocationID allocationID = new AllocationID();
        boolean subtaskIndex = true;
        int attempt = 2;
        return new ArchivedExecutionJobVertex(new ArchivedExecutionVertex[]{new ArchivedExecutionVertex(1, "test task", new ArchivedExecution(new StringifiedAccumulatorResult[0], null, new ExecutionAttemptID(), 2, expectedState, "error", (TaskManagerLocation)assignedResourceLocation, allocationID, 1, timestamps), new EvictingBoundedList(0))}, jobVertexID, jobVertexID.toString(), 1, 1, ResourceProfile.UNKNOWN, emptyAccumulators);
    }

    private static HandlerRequest<EmptyRequestBody, JobExceptionsMessageParameters> createRequest(JobID jobId, int size) throws HandlerRequestException {
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        pathParameters.put("jobid", jobId.toString());
        HashMap<String, List<String>> queryParameters = new HashMap<String, List<String>>();
        queryParameters.put("maxExceptions", Collections.singletonList("" + size));
        return new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new JobExceptionsMessageParameters(), pathParameters, queryParameters);
    }
}

