/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.scheduler.DeploymentHandle;
import org.apache.flink.runtime.scheduler.DeploymentOption;
import org.apache.flink.runtime.scheduler.ExecutionVertexDeploymentOption;
import org.apache.flink.runtime.scheduler.ExecutionVertexVersion;
import org.apache.flink.runtime.scheduler.SlotExecutionVertexAssignment;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeploymentHandleTest {
    private static final JobVertexID TEST_JOB_VERTEX_ID = new JobVertexID(0L, 0L);
    private static final ExecutionVertexID TEST_EXECUTION_VERTEX_ID = new ExecutionVertexID(TEST_JOB_VERTEX_ID, 0);
    private static final ExecutionVertexVersion TEST_EXECUTION_VERTEX_VERSION = new ExecutionVertexVersion(TEST_EXECUTION_VERTEX_ID, 0L);
    private static final ExecutionVertexDeploymentOption TEST_DEPLOYMENT_OPTION = new ExecutionVertexDeploymentOption(TEST_EXECUTION_VERTEX_ID, new DeploymentOption(true));
    private CompletableFuture<LogicalSlot> logicalSlotFuture;
    private DeploymentHandle deploymentHandle;

    @Before
    public void setUp() {
        this.logicalSlotFuture = new CompletableFuture();
        SlotExecutionVertexAssignment slotExecutionVertexAssignment = new SlotExecutionVertexAssignment(TEST_EXECUTION_VERTEX_ID, this.logicalSlotFuture);
        this.deploymentHandle = new DeploymentHandle(TEST_EXECUTION_VERTEX_VERSION, TEST_DEPLOYMENT_OPTION, slotExecutionVertexAssignment);
    }

    @Test
    public void getLogicalSlotThrowsExceptionIfSlotFutureNotCompleted() {
        try {
            Assert.assertFalse((boolean)this.deploymentHandle.getLogicalSlot().isPresent());
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"method can only be called after slot future is done"));
        }
    }

    @Test
    public void slotIsNotPresentIfFutureWasCancelled() {
        this.logicalSlotFuture.cancel(false);
        Assert.assertFalse((boolean)this.deploymentHandle.getLogicalSlot().isPresent());
    }

    @Test
    public void slotIsNotPresentIfFutureWasCompletedExceptionally() {
        this.logicalSlotFuture.completeExceptionally(new RuntimeException("expected"));
        Assert.assertFalse((boolean)this.deploymentHandle.getLogicalSlot().isPresent());
    }

    @Test
    public void getLogicalSlotReturnsSlotIfFutureCompletedNormally() {
        TestingLogicalSlot logicalSlot = new TestingLogicalSlotBuilder().createTestingLogicalSlot();
        this.logicalSlotFuture.complete(logicalSlot);
        Assert.assertTrue((boolean)this.deploymentHandle.getLogicalSlot().isPresent());
        Assert.assertSame((Object)logicalSlot, this.deploymentHandle.getLogicalSlot().get());
    }
}

