/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.scheduler.ExecutionSlotAllocator;
import org.apache.flink.runtime.scheduler.ExecutionVertexSchedulingRequirements;
import org.apache.flink.runtime.scheduler.SlotExecutionVertexAssignment;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class TestExecutionSlotAllocator
implements ExecutionSlotAllocator,
SlotOwner {
    private final Map<ExecutionVertexID, SlotExecutionVertexAssignment> pendingRequests = new HashMap<ExecutionVertexID, SlotExecutionVertexAssignment>();
    private final TestingLogicalSlotBuilder logicalSlotBuilder = new TestingLogicalSlotBuilder();
    private boolean autoCompletePendingRequests = true;
    private final List<LogicalSlot> returnedSlots = new ArrayList<LogicalSlot>();

    public TestExecutionSlotAllocator() {
    }

    public TestExecutionSlotAllocator(TaskManagerGateway taskManagerGateway) {
        this.logicalSlotBuilder.setTaskManagerGateway(taskManagerGateway);
    }

    public List<SlotExecutionVertexAssignment> allocateSlotsFor(List<ExecutionVertexSchedulingRequirements> schedulingRequirementsCollection) {
        List<SlotExecutionVertexAssignment> slotVertexAssignments = this.createSlotVertexAssignments(schedulingRequirementsCollection);
        this.registerPendingRequests(slotVertexAssignments);
        this.maybeCompletePendingRequests();
        return slotVertexAssignments;
    }

    private void registerPendingRequests(List<SlotExecutionVertexAssignment> slotVertexAssignments) {
        for (SlotExecutionVertexAssignment slotVertexAssignment : slotVertexAssignments) {
            this.pendingRequests.put(slotVertexAssignment.getExecutionVertexId(), slotVertexAssignment);
        }
    }

    private List<SlotExecutionVertexAssignment> createSlotVertexAssignments(Collection<ExecutionVertexSchedulingRequirements> schedulingRequirementsCollection) {
        ArrayList<SlotExecutionVertexAssignment> result = new ArrayList<SlotExecutionVertexAssignment>();
        for (ExecutionVertexSchedulingRequirements schedulingRequirements : schedulingRequirementsCollection) {
            ExecutionVertexID executionVertexId = schedulingRequirements.getExecutionVertexId();
            CompletableFuture logicalSlotFuture = new CompletableFuture();
            result.add(new SlotExecutionVertexAssignment(executionVertexId, logicalSlotFuture));
        }
        return result;
    }

    private void maybeCompletePendingRequests() {
        if (this.autoCompletePendingRequests) {
            this.completePendingRequests();
        }
    }

    public void completePendingRequests() {
        ArrayList<ExecutionVertexID> vertexIds = new ArrayList<ExecutionVertexID>(this.pendingRequests.keySet());
        vertexIds.forEach(this::completePendingRequest);
    }

    public void completePendingRequest(ExecutionVertexID executionVertexId) {
        SlotExecutionVertexAssignment slotVertexAssignment = this.removePendingRequest(executionVertexId);
        Preconditions.checkState((slotVertexAssignment != null ? 1 : 0) != 0);
        slotVertexAssignment.getLogicalSlotFuture().complete(this.logicalSlotBuilder.setSlotOwner(this).createTestingLogicalSlot());
    }

    private SlotExecutionVertexAssignment removePendingRequest(ExecutionVertexID executionVertexId) {
        return this.pendingRequests.remove(executionVertexId);
    }

    public void timeoutPendingRequests() {
        ArrayList<ExecutionVertexID> vertexIds = new ArrayList<ExecutionVertexID>(this.pendingRequests.keySet());
        vertexIds.forEach(this::timeoutPendingRequest);
    }

    public void timeoutPendingRequest(ExecutionVertexID executionVertexId) {
        SlotExecutionVertexAssignment slotVertexAssignment = this.removePendingRequest(executionVertexId);
        Preconditions.checkState((slotVertexAssignment != null ? 1 : 0) != 0);
        slotVertexAssignment.getLogicalSlotFuture().completeExceptionally(new TimeoutException());
    }

    public void enableAutoCompletePendingRequests() {
        this.autoCompletePendingRequests = true;
    }

    public void disableAutoCompletePendingRequests() {
        this.autoCompletePendingRequests = false;
    }

    public void cancel(ExecutionVertexID executionVertexId) {
        SlotExecutionVertexAssignment slotVertexAssignment = this.removePendingRequest(executionVertexId);
        if (slotVertexAssignment != null) {
            slotVertexAssignment.getLogicalSlotFuture().cancel(false);
        }
    }

    public CompletableFuture<Void> stop() {
        return CompletableFuture.completedFuture(null);
    }

    public void returnLogicalSlot(LogicalSlot logicalSlot) {
        this.returnedSlots.add(logicalSlot);
    }

    public List<LogicalSlot> getReturnedSlots() {
        return new ArrayList<LogicalSlot>(this.returnedSlots);
    }

    public TestingLogicalSlotBuilder getLogicalSlotBuilder() {
        return this.logicalSlotBuilder;
    }
}

