/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.runtime.accumulators.AccumulatorSnapshot;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmanager.PartitionProducerDisposedException;
import org.apache.flink.runtime.jobmaster.SerializedInputSplit;
import org.apache.flink.runtime.messages.checkpoint.DeclineCheckpoint;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.query.KvStateLocation;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.OperatorBackPressureStats;
import org.apache.flink.runtime.scheduler.SchedulerNG;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;

public class TestingSchedulerNG
implements SchedulerNG {
    private final CompletableFuture<Void> terminationFuture;
    private final Runnable startSchedulingRunnable;
    private final Consumer<Throwable> suspendConsumer;
    private final BiFunction<String, Boolean, CompletableFuture<String>> triggerSavepointFunction;
    private final Consumer<Throwable> handleGlobalFailureConsumer;

    public TestingSchedulerNG(CompletableFuture<Void> terminationFuture, Runnable startSchedulingRunnable, Consumer<Throwable> suspendConsumer, BiFunction<String, Boolean, CompletableFuture<String>> triggerSavepointFunction, Consumer<Throwable> handleGlobalFailureConsumer) {
        this.terminationFuture = terminationFuture;
        this.startSchedulingRunnable = startSchedulingRunnable;
        this.suspendConsumer = suspendConsumer;
        this.triggerSavepointFunction = triggerSavepointFunction;
        this.handleGlobalFailureConsumer = handleGlobalFailureConsumer;
    }

    public void setMainThreadExecutor(ComponentMainThreadExecutor mainThreadExecutor) {
    }

    public void registerJobStatusListener(JobStatusListener jobStatusListener) {
    }

    public void startScheduling() {
        this.startSchedulingRunnable.run();
    }

    private void failOperation() {
        throw new UnsupportedOperationException("This operation is not supported.");
    }

    public void suspend(Throwable cause) {
        this.suspendConsumer.accept(cause);
    }

    public void cancel() {
    }

    public CompletableFuture<Void> getTerminationFuture() {
        return this.terminationFuture;
    }

    public void handleGlobalFailure(Throwable cause) {
        this.handleGlobalFailureConsumer.accept(cause);
    }

    public boolean updateTaskExecutionState(TaskExecutionState taskExecutionState) {
        this.failOperation();
        return false;
    }

    public SerializedInputSplit requestNextInputSplit(JobVertexID vertexID, ExecutionAttemptID executionAttempt) throws IOException {
        this.failOperation();
        return null;
    }

    public ExecutionState requestPartitionState(IntermediateDataSetID intermediateResultId, ResultPartitionID resultPartitionId) throws PartitionProducerDisposedException {
        this.failOperation();
        return null;
    }

    public void scheduleOrUpdateConsumers(ResultPartitionID partitionID) {
        this.failOperation();
    }

    public ArchivedExecutionGraph requestJob() {
        this.failOperation();
        return null;
    }

    public JobStatus requestJobStatus() {
        return JobStatus.CREATED;
    }

    public JobDetails requestJobDetails() {
        this.failOperation();
        return null;
    }

    public KvStateLocation requestKvStateLocation(JobID jobId, String registrationName) {
        this.failOperation();
        return null;
    }

    public void notifyKvStateRegistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName, KvStateID kvStateId, InetSocketAddress kvStateServerAddress) {
        this.failOperation();
    }

    public void notifyKvStateUnregistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName) {
        this.failOperation();
    }

    public void updateAccumulators(AccumulatorSnapshot accumulatorSnapshot) {
        this.failOperation();
    }

    public Optional<OperatorBackPressureStats> requestOperatorBackPressureStats(JobVertexID jobVertexId) {
        this.failOperation();
        return Optional.empty();
    }

    public CompletableFuture<String> triggerSavepoint(@Nullable String targetDirectory, boolean cancelJob) {
        this.failOperation();
        return null;
    }

    public void acknowledgeCheckpoint(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointMetrics checkpointMetrics, TaskStateSnapshot checkpointState) {
        this.failOperation();
    }

    public void declineCheckpoint(DeclineCheckpoint decline) {
        this.failOperation();
    }

    public CompletableFuture<String> stopWithSavepoint(String targetDirectory, boolean terminate) {
        this.failOperation();
        return null;
    }

    public void deliverOperatorEventToCoordinator(ExecutionAttemptID taskExecution, OperatorID operator, OperatorEvent evt) {
        this.failOperation();
    }

    public CompletableFuture<CoordinationResponse> deliverCoordinationRequestToCoordinator(OperatorID operator, CoordinationRequest request) {
        this.failOperation();
        return null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private CompletableFuture<Void> terminationFuture = new CompletableFuture();
        private Runnable startSchedulingRunnable = () -> {};
        private Consumer<Throwable> suspendConsumer = ignored -> {};
        private BiFunction<String, Boolean, CompletableFuture<String>> triggerSavepointFunction = (ignoredA, ignoredB) -> new CompletableFuture();
        private Consumer<Throwable> handleGlobalFailureConsumer = ignored -> {};

        public Builder setTerminationFuture(CompletableFuture<Void> terminationFuture) {
            this.terminationFuture = terminationFuture;
            return this;
        }

        public Builder setStartSchedulingRunnable(Runnable startSchedulingRunnable) {
            this.startSchedulingRunnable = startSchedulingRunnable;
            return this;
        }

        public Builder setSuspendConsumer(Consumer<Throwable> suspendConsumer) {
            this.suspendConsumer = suspendConsumer;
            return this;
        }

        public Builder setTriggerSavepointFunction(BiFunction<String, Boolean, CompletableFuture<String>> triggerSavepointFunction) {
            this.triggerSavepointFunction = triggerSavepointFunction;
            return this;
        }

        public Builder setHandleGlobalFailureConsumer(Consumer<Throwable> handleGlobalFailureConsumer) {
            this.handleGlobalFailureConsumer = handleGlobalFailureConsumer;
            return this;
        }

        public TestingSchedulerNG build() {
            return new TestingSchedulerNG(this.terminationFuture, this.startSchedulingRunnable, this.suspendConsumer, this.triggerSavepointFunction, this.handleGlobalFailureConsumer);
        }
    }
}

