/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.InputDependencyConstraint;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionTopology;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionVertex;
import org.apache.flink.runtime.scheduler.adapter.DefaultResultPartition;
import org.apache.flink.runtime.scheduler.adapter.DefaultSchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.shaded.guava18.com.google.common.collect.Iterables;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSchedulingPipelinedRegionTest
extends TestLogger {
    @Test
    public void gettingUnknownVertexThrowsException() {
        DefaultSchedulingPipelinedRegion pipelinedRegion = new DefaultSchedulingPipelinedRegion(Collections.emptySet());
        ExecutionVertexID unknownVertexId = new ExecutionVertexID(new JobVertexID(), 0);
        try {
            pipelinedRegion.getVertex(unknownVertexId);
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)(unknownVertexId + " not found")));
        }
    }

    @Test
    public void returnsVertices() {
        DefaultExecutionVertex vertex = new DefaultExecutionVertex(new ExecutionVertexID(new JobVertexID(), 0), Collections.emptyList(), () -> ExecutionState.CREATED, InputDependencyConstraint.ANY);
        Set<DefaultExecutionVertex> vertices = Collections.singleton(vertex);
        DefaultSchedulingPipelinedRegion pipelinedRegion = new DefaultSchedulingPipelinedRegion(vertices);
        Iterator vertexIterator = pipelinedRegion.getVertices().iterator();
        Assert.assertThat((Object)vertexIterator.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat(vertexIterator.next(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)vertex)));
        Assert.assertThat((Object)vertexIterator.hasNext(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void returnsIncidentBlockingPartitions() throws Exception {
        JobVertex a = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobVertex b = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobVertex c = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobVertex d = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobVertex e = ExecutionGraphTestUtils.createNoOpVertex(1);
        b.connectNewDataSetAsInput(a, DistributionPattern.POINTWISE, ResultPartitionType.BLOCKING);
        c.connectNewDataSetAsInput(b, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        d.connectNewDataSetAsInput(b, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        e.connectNewDataSetAsInput(c, DistributionPattern.POINTWISE, ResultPartitionType.BLOCKING);
        e.connectNewDataSetAsInput(d, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        ExecutionGraph simpleTestGraph = ExecutionGraphTestUtils.createSimpleTestGraph(a, b, c, d, e);
        DefaultExecutionTopology topology = new DefaultExecutionTopology(simpleTestGraph);
        DefaultSchedulingPipelinedRegion firstPipelinedRegion = topology.getPipelinedRegionOfVertex(new ExecutionVertexID(a.getID(), 0));
        DefaultSchedulingPipelinedRegion secondPipelinedRegion = topology.getPipelinedRegionOfVertex(new ExecutionVertexID(e.getID(), 0));
        DefaultExecutionVertex vertexB0 = topology.getVertex(new ExecutionVertexID(b.getID(), 0));
        IntermediateResultPartitionID b0ConsumedResultPartition = ((DefaultResultPartition)Iterables.getOnlyElement((Iterable)vertexB0.getConsumedResults())).getId();
        Set secondPipelinedRegionConsumedResults = IterableUtils.toStream((Iterable)secondPipelinedRegion.getConsumedResults()).map(DefaultResultPartition::getId).collect(Collectors.toSet());
        Assert.assertThat((Object)firstPipelinedRegion.getConsumedResults().iterator().hasNext(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat(secondPipelinedRegionConsumedResults, (Matcher)Matchers.contains((Object[])new IntermediateResultPartitionID[]{b0ConsumedResultPartition}));
    }
}

