/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.ExecutionVertexDeploymentOption;
import org.apache.flink.runtime.scheduler.SchedulerOperations;
import org.apache.flink.runtime.scheduler.strategy.EagerSchedulingStrategy;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.runtime.scheduler.strategy.StrategyTestUtil;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulerOperations;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingTopology;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EagerSchedulingStrategyTest
extends TestLogger {
    private TestingSchedulerOperations testingSchedulerOperations;
    private TestingSchedulingTopology testingSchedulingTopology;
    private EagerSchedulingStrategy schedulingStrategy;

    @Before
    public void setUp() {
        this.testingSchedulerOperations = new TestingSchedulerOperations();
        this.testingSchedulingTopology = new TestingSchedulingTopology();
        this.schedulingStrategy = new EagerSchedulingStrategy((SchedulerOperations)this.testingSchedulerOperations, (SchedulingTopology)this.testingSchedulingTopology);
    }

    @Test
    public void testStartScheduling() {
        JobVertexID jobVertexID = new JobVertexID();
        List<TestingSchedulingExecutionVertex> executionVertices = Arrays.asList(new TestingSchedulingExecutionVertex(jobVertexID, 4), new TestingSchedulingExecutionVertex(jobVertexID, 0), new TestingSchedulingExecutionVertex(jobVertexID, 2), new TestingSchedulingExecutionVertex(jobVertexID, 1), new TestingSchedulingExecutionVertex(jobVertexID, 3));
        this.testingSchedulingTopology.addSchedulingExecutionVertices(executionVertices);
        this.schedulingStrategy.startScheduling();
        Assert.assertThat(this.testingSchedulerOperations.getScheduledVertices(), (Matcher)Matchers.hasSize((int)1));
        List<ExecutionVertexDeploymentOption> scheduledVertices = this.testingSchedulerOperations.getScheduledVertices().get(0);
        List<ExecutionVertexID> scheduledVertexIDs = StrategyTestUtil.getExecutionVertexIdsFromDeployOptions(scheduledVertices);
        List executionVertexIDs = executionVertices.stream().map(TestingSchedulingExecutionVertex::getId).collect(Collectors.toList());
        Assert.assertEquals(executionVertexIDs, scheduledVertexIDs);
    }

    @Test
    public void testRestartTasks() {
        JobVertexID jobVertexID = new JobVertexID();
        List<TestingSchedulingExecutionVertex> executionVertices = Arrays.asList(new TestingSchedulingExecutionVertex(jobVertexID, 4), new TestingSchedulingExecutionVertex(jobVertexID, 0), new TestingSchedulingExecutionVertex(jobVertexID, 2), new TestingSchedulingExecutionVertex(jobVertexID, 1), new TestingSchedulingExecutionVertex(jobVertexID, 3));
        this.testingSchedulingTopology.addSchedulingExecutionVertices(executionVertices);
        List<ExecutionVertexID> verticesToRestart1 = Arrays.asList(new ExecutionVertexID(jobVertexID, 4), new ExecutionVertexID(jobVertexID, 0));
        this.schedulingStrategy.restartTasks(new HashSet<ExecutionVertexID>(verticesToRestart1));
        List<ExecutionVertexID> verticesToRestart2 = Arrays.asList(new ExecutionVertexID(jobVertexID, 2), new ExecutionVertexID(jobVertexID, 1), new ExecutionVertexID(jobVertexID, 3));
        this.schedulingStrategy.restartTasks(new HashSet<ExecutionVertexID>(verticesToRestart2));
        Assert.assertThat(this.testingSchedulerOperations.getScheduledVertices(), (Matcher)Matchers.hasSize((int)2));
        List<ExecutionVertexDeploymentOption> scheduledVertices1 = this.testingSchedulerOperations.getScheduledVertices().get(0);
        Assert.assertEquals(verticesToRestart1, StrategyTestUtil.getExecutionVertexIdsFromDeployOptions(scheduledVertices1));
        List<ExecutionVertexDeploymentOption> scheduledVertices2 = this.testingSchedulerOperations.getScheduledVertices().get(1);
        Assert.assertEquals(verticesToRestart2, StrategyTestUtil.getExecutionVertexIdsFromDeployOptions(scheduledVertices2));
    }
}

