/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.InputDependencyConstraint;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.InputDependencyConstraintChecker;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingResultPartition;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingResultPartition;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class InputDependencyConstraintCheckerTest
extends TestLogger {
    @Test
    public void testCheckInputVertex() {
        TestingSchedulingExecutionVertex vertex = InputDependencyConstraintCheckerTest.addSchedulingExecutionVertex().finish();
        InputDependencyConstraintChecker inputChecker = InputDependencyConstraintCheckerTest.createInputDependencyConstraintChecker(Collections.emptyList());
        Assert.assertTrue((boolean)inputChecker.check((SchedulingExecutionVertex)vertex));
    }

    @Test
    public void testCheckCreatedPipelinedInput() {
        List<TestingSchedulingResultPartition> partitions = InputDependencyConstraintCheckerTest.addResultPartition().withPartitionType(ResultPartitionType.PIPELINED).withPartitionState(ResultPartitionState.CREATED).finish();
        TestingSchedulingExecutionVertex vertex = InputDependencyConstraintCheckerTest.addSchedulingExecutionVertex().withConsumedPartitions(partitions).finish();
        InputDependencyConstraintChecker inputChecker = InputDependencyConstraintCheckerTest.createInputDependencyConstraintChecker(partitions);
        Assert.assertFalse((boolean)inputChecker.check((SchedulingExecutionVertex)vertex));
    }

    @Test
    public void testCheckConsumablePipelinedInput() {
        List<TestingSchedulingResultPartition> partitions = InputDependencyConstraintCheckerTest.addResultPartition().withPartitionType(ResultPartitionType.PIPELINED).withPartitionState(ResultPartitionState.CONSUMABLE).finish();
        TestingSchedulingExecutionVertex vertex = InputDependencyConstraintCheckerTest.addSchedulingExecutionVertex().withConsumedPartitions(partitions).finish();
        InputDependencyConstraintChecker inputChecker = InputDependencyConstraintCheckerTest.createInputDependencyConstraintChecker(partitions);
        Assert.assertTrue((boolean)inputChecker.check((SchedulingExecutionVertex)vertex));
    }

    @Test
    public void testCheckDoneBlockingInput() {
        List<TestingSchedulingResultPartition> partitions = InputDependencyConstraintCheckerTest.addResultPartition().withPartitionCntPerDataSet(2).finish();
        TestingSchedulingExecutionVertex vertex = InputDependencyConstraintCheckerTest.addSchedulingExecutionVertex().withConsumedPartitions(partitions).finish();
        InputDependencyConstraintChecker inputChecker = InputDependencyConstraintCheckerTest.createInputDependencyConstraintChecker(partitions);
        for (TestingSchedulingResultPartition srp : partitions) {
            inputChecker.markSchedulingResultPartitionFinished((SchedulingResultPartition)srp);
        }
        Assert.assertTrue((boolean)inputChecker.check((SchedulingExecutionVertex)vertex));
    }

    @Test
    public void testCheckPartialDoneBlockingInput() {
        List<TestingSchedulingResultPartition> partitions = InputDependencyConstraintCheckerTest.addResultPartition().withPartitionCntPerDataSet(2).finish();
        TestingSchedulingExecutionVertex vertex = InputDependencyConstraintCheckerTest.addSchedulingExecutionVertex().withConsumedPartitions(partitions).finish();
        InputDependencyConstraintChecker inputChecker = InputDependencyConstraintCheckerTest.createInputDependencyConstraintChecker(partitions);
        inputChecker.markSchedulingResultPartitionFinished((SchedulingResultPartition)partitions.get(0));
        Assert.assertFalse((boolean)inputChecker.check((SchedulingExecutionVertex)vertex));
    }

    @Test
    public void testCheckResetBlockingInput() {
        List<TestingSchedulingResultPartition> partitions = InputDependencyConstraintCheckerTest.addResultPartition().withPartitionCntPerDataSet(2).finish();
        TestingSchedulingExecutionVertex vertex = InputDependencyConstraintCheckerTest.addSchedulingExecutionVertex().withConsumedPartitions(partitions).finish();
        InputDependencyConstraintChecker inputChecker = InputDependencyConstraintCheckerTest.createInputDependencyConstraintChecker(partitions);
        for (TestingSchedulingResultPartition srp : partitions) {
            inputChecker.markSchedulingResultPartitionFinished((SchedulingResultPartition)srp);
        }
        for (TestingSchedulingResultPartition srp : partitions) {
            inputChecker.resetSchedulingResultPartition((SchedulingResultPartition)srp);
        }
        Assert.assertFalse((boolean)inputChecker.check((SchedulingExecutionVertex)vertex));
    }

    @Test
    public void testCheckAnyBlockingInput() {
        List<TestingSchedulingResultPartition> partitions = InputDependencyConstraintCheckerTest.addResultPartition().withDataSetCnt(2).finish();
        TestingSchedulingExecutionVertex vertex = InputDependencyConstraintCheckerTest.addSchedulingExecutionVertex().withConsumedPartitions(partitions).finish();
        InputDependencyConstraintChecker inputChecker = InputDependencyConstraintCheckerTest.createInputDependencyConstraintChecker(partitions);
        inputChecker.markSchedulingResultPartitionFinished((SchedulingResultPartition)partitions.get(0));
        Assert.assertTrue((boolean)inputChecker.check((SchedulingExecutionVertex)vertex));
    }

    @Test
    public void testCheckAllBlockingInput() {
        List<TestingSchedulingResultPartition> partitions = InputDependencyConstraintCheckerTest.addResultPartition().withDataSetCnt(2).finish();
        TestingSchedulingExecutionVertex vertex = InputDependencyConstraintCheckerTest.addSchedulingExecutionVertex().withInputDependencyConstraint(InputDependencyConstraint.ALL).withConsumedPartitions(partitions).finish();
        InputDependencyConstraintChecker inputChecker = InputDependencyConstraintCheckerTest.createInputDependencyConstraintChecker(partitions);
        for (TestingSchedulingResultPartition srp : partitions) {
            inputChecker.markSchedulingResultPartitionFinished((SchedulingResultPartition)srp);
        }
        Assert.assertTrue((boolean)inputChecker.check((SchedulingExecutionVertex)vertex));
    }

    @Test
    public void testCheckAllPartialDatasetBlockingInput() {
        List<TestingSchedulingResultPartition> partitions = InputDependencyConstraintCheckerTest.addResultPartition().withDataSetCnt(2).finish();
        TestingSchedulingExecutionVertex vertex = InputDependencyConstraintCheckerTest.addSchedulingExecutionVertex().withInputDependencyConstraint(InputDependencyConstraint.ALL).withConsumedPartitions(partitions).finish();
        InputDependencyConstraintChecker inputChecker = InputDependencyConstraintCheckerTest.createInputDependencyConstraintChecker(partitions);
        inputChecker.markSchedulingResultPartitionFinished((SchedulingResultPartition)partitions.get(0));
        Assert.assertFalse((boolean)inputChecker.check((SchedulingExecutionVertex)vertex));
    }

    @Test
    public void testCheckAllPartialPartitionBlockingInput() {
        List<TestingSchedulingResultPartition> partitions = InputDependencyConstraintCheckerTest.addResultPartition().withDataSetCnt(2).withPartitionCntPerDataSet(2).finish();
        TestingSchedulingExecutionVertex vertex = InputDependencyConstraintCheckerTest.addSchedulingExecutionVertex().withInputDependencyConstraint(InputDependencyConstraint.ALL).withConsumedPartitions(partitions).finish();
        InputDependencyConstraintChecker inputChecker = InputDependencyConstraintCheckerTest.createInputDependencyConstraintChecker(partitions);
        for (int idx = 0; idx < 3; ++idx) {
            inputChecker.markSchedulingResultPartitionFinished((SchedulingResultPartition)partitions.get(idx));
        }
        Assert.assertFalse((boolean)inputChecker.check((SchedulingExecutionVertex)vertex));
    }

    private static TestingSchedulingExecutionVertexBuilder addSchedulingExecutionVertex() {
        return new TestingSchedulingExecutionVertexBuilder();
    }

    private static TestingSchedulingResultPartitionBuilder addResultPartition() {
        return new TestingSchedulingResultPartitionBuilder();
    }

    private static InputDependencyConstraintChecker createInputDependencyConstraintChecker(List<TestingSchedulingResultPartition> partitions) {
        InputDependencyConstraintChecker inputChecker = new InputDependencyConstraintChecker();
        for (SchedulingResultPartition schedulingResultPartition : partitions) {
            inputChecker.addSchedulingResultPartition(schedulingResultPartition);
        }
        return inputChecker;
    }

    private static class TestingSchedulingResultPartitionBuilder {
        private int dataSetCnt = 1;
        private int partitionCntPerDataSet = 1;
        private ResultPartitionType partitionType = ResultPartitionType.BLOCKING;
        private ResultPartitionState partitionState = ResultPartitionState.CONSUMABLE;

        private TestingSchedulingResultPartitionBuilder() {
        }

        TestingSchedulingResultPartitionBuilder withDataSetCnt(int dataSetCnt) {
            this.dataSetCnt = dataSetCnt;
            return this;
        }

        TestingSchedulingResultPartitionBuilder withPartitionCntPerDataSet(int partitionCnt) {
            this.partitionCntPerDataSet = partitionCnt;
            return this;
        }

        TestingSchedulingResultPartitionBuilder withPartitionType(ResultPartitionType type) {
            this.partitionType = type;
            return this;
        }

        TestingSchedulingResultPartitionBuilder withPartitionState(ResultPartitionState state) {
            this.partitionState = state;
            return this;
        }

        List<TestingSchedulingResultPartition> finish() {
            ArrayList<TestingSchedulingResultPartition> partitions = new ArrayList<TestingSchedulingResultPartition>(this.dataSetCnt * this.partitionCntPerDataSet);
            for (int dataSetIdx = 0; dataSetIdx < this.dataSetCnt; ++dataSetIdx) {
                IntermediateDataSetID dataSetId = new IntermediateDataSetID();
                for (int partitionIdx = 0; partitionIdx < this.partitionCntPerDataSet; ++partitionIdx) {
                    partitions.add(new TestingSchedulingResultPartition(dataSetId, this.partitionType, this.partitionState));
                }
            }
            return partitions;
        }
    }

    private static class TestingSchedulingExecutionVertexBuilder {
        private static final JobVertexID jobVertexId = new JobVertexID();
        private InputDependencyConstraint inputDependencyConstraint = InputDependencyConstraint.ANY;
        private List<TestingSchedulingResultPartition> partitions = Collections.emptyList();

        private TestingSchedulingExecutionVertexBuilder() {
        }

        TestingSchedulingExecutionVertexBuilder withInputDependencyConstraint(InputDependencyConstraint constraint) {
            this.inputDependencyConstraint = constraint;
            return this;
        }

        TestingSchedulingExecutionVertexBuilder withConsumedPartitions(List<TestingSchedulingResultPartition> partitions) {
            this.partitions = partitions;
            return this;
        }

        TestingSchedulingExecutionVertex finish() {
            return new TestingSchedulingExecutionVertex(jobVertexId, 0, this.inputDependencyConstraint, this.partitions);
        }
    }
}

