/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingResultPartition;

public class TestingSchedulingPipelinedRegion
implements SchedulingPipelinedRegion {
    private final Map<ExecutionVertexID, TestingSchedulingExecutionVertex> regionVertices = new HashMap<ExecutionVertexID, TestingSchedulingExecutionVertex>();
    private final Set<TestingSchedulingResultPartition> consumedPartitions = new HashSet<TestingSchedulingResultPartition>();

    public TestingSchedulingPipelinedRegion(Set<TestingSchedulingExecutionVertex> vertices) {
        for (TestingSchedulingExecutionVertex vertex : vertices) {
            this.regionVertices.put(vertex.getId(), vertex);
            for (TestingSchedulingResultPartition consumedPartition : vertex.getConsumedResults()) {
                if (vertices.contains(consumedPartition.getProducer())) continue;
                this.consumedPartitions.add(consumedPartition);
            }
        }
    }

    public Iterable<TestingSchedulingExecutionVertex> getVertices() {
        return Collections.unmodifiableCollection(this.regionVertices.values());
    }

    public TestingSchedulingExecutionVertex getVertex(ExecutionVertexID vertexId) {
        TestingSchedulingExecutionVertex executionVertex = this.regionVertices.get(vertexId);
        if (executionVertex == null) {
            throw new IllegalArgumentException(String.format("Execution vertex %s not found in pipelined region", vertexId));
        }
        return executionVertex;
    }

    public Iterable<TestingSchedulingResultPartition> getConsumedResults() {
        return Collections.unmodifiableSet(this.consumedPartitions);
    }
}

