/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.KeyExtractorFunction;
import org.apache.flink.runtime.state.KeyGroupPartitioner;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.StateSnapshot;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public abstract class KeyGroupPartitionerTestBase<T>
extends TestLogger {
    private static final DataOutputView DUMMY_OUT_VIEW = new DataOutputViewStreamWrapper((OutputStream)new ByteArrayOutputStreamWithPos(0));
    @Nonnull
    protected final KeyExtractorFunction<T> keyExtractorFunction;
    @Nonnull
    protected final Function<Random, T> elementGenerator;

    protected KeyGroupPartitionerTestBase(@Nonnull Function<Random, T> elementGenerator, @Nonnull KeyExtractorFunction<T> keyExtractorFunction) {
        this.elementGenerator = elementGenerator;
        this.keyExtractorFunction = keyExtractorFunction;
    }

    @Test
    public void testPartitionByKeyGroup() throws IOException {
        Random random = new Random(66L);
        this.testPartitionByKeyGroupForSize(0, random);
        this.testPartitionByKeyGroupForSize(1, random);
        this.testPartitionByKeyGroupForSize(2, random);
        this.testPartitionByKeyGroupForSize(10, random);
    }

    private void testPartitionByKeyGroupForSize(int testSize, Random random) throws IOException {
        Set allElementsIdentitySet = Collections.newSetFromMap(new IdentityHashMap());
        K[] data = this.generateTestInput(random, testSize, allElementsIdentitySet);
        Assert.assertEquals((long)testSize, (long)allElementsIdentitySet.size());
        KeyGroupRange range = new KeyGroupRange(0, 4);
        int numberOfKeyGroups = range.getNumberOfKeyGroups();
        ValidatingElementWriterDummy<T> validatingElementWriter = new ValidatingElementWriterDummy<T>(this.keyExtractorFunction, numberOfKeyGroups, allElementsIdentitySet);
        KeyGroupPartitioner testInstance = this.createPartitioner(data, testSize, range, numberOfKeyGroups, validatingElementWriter);
        StateSnapshot.StateKeyGroupWriter result = testInstance.partitionByKeyGroup();
        for (int keyGroup = 0; keyGroup < numberOfKeyGroups; ++keyGroup) {
            validatingElementWriter.setCurrentKeyGroup(keyGroup);
            result.writeStateInKeyGroup(DUMMY_OUT_VIEW, keyGroup);
        }
        validatingElementWriter.validateAllElementsSeen();
    }

    protected T[] generateTestInput(Random random, int numElementsToGenerate, Set<T> allElementsIdentitySet) {
        int arraySize = numElementsToGenerate > 1 ? numElementsToGenerate + 5 : numElementsToGenerate;
        T element = this.elementGenerator.apply(random);
        Object[] partitioningIn = (Object[])Array.newInstance(element.getClass(), arraySize);
        for (int i = 0; i < numElementsToGenerate; ++i) {
            partitioningIn[i] = element;
            allElementsIdentitySet.add(element);
            element = this.elementGenerator.apply(random);
        }
        Assert.assertEquals((long)numElementsToGenerate, (long)allElementsIdentitySet.size());
        return partitioningIn;
    }

    protected KeyGroupPartitioner<T> createPartitioner(T[] data, int numElements, KeyGroupRange keyGroupRange, int totalKeyGroups, KeyGroupPartitioner.ElementWriterFunction<T> elementWriterFunction) {
        Object[] partitioningOut = (Object[])Array.newInstance(data.getClass().getComponentType(), numElements);
        return new KeyGroupPartitioner((Object[])data, numElements, partitioningOut, keyGroupRange, totalKeyGroups, this.keyExtractorFunction, elementWriterFunction);
    }

    static final class ValidatingElementWriterDummy<T>
    implements KeyGroupPartitioner.ElementWriterFunction<T> {
        @Nonnull
        private final KeyExtractorFunction<T> keyExtractorFunction;
        @Nonnegative
        private final int numberOfKeyGroups;
        @Nonnull
        private final Set<T> allElementsSet;
        @Nonnegative
        private int currentKeyGroup;

        ValidatingElementWriterDummy(@Nonnull KeyExtractorFunction<T> keyExtractorFunction, @Nonnegative int numberOfKeyGroups, @Nonnull Set<T> allElementsSet) {
            this.keyExtractorFunction = keyExtractorFunction;
            this.numberOfKeyGroups = numberOfKeyGroups;
            this.allElementsSet = allElementsSet;
        }

        public void writeElement(@Nonnull T element, @Nonnull DataOutputView dov) {
            Assert.assertTrue((boolean)this.allElementsSet.remove(element));
            Assert.assertEquals((long)this.currentKeyGroup, (long)KeyGroupRangeAssignment.assignToKeyGroup((Object)this.keyExtractorFunction.extractKeyFromElement(element), (int)this.numberOfKeyGroups));
        }

        void validateAllElementsSeen() {
            Assert.assertTrue((boolean)this.allElementsSet.isEmpty());
        }

        void setCurrentKeyGroup(int currentKeyGroup) {
            this.currentKeyGroup = currentKeyGroup;
        }
    }
}

