/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeOffsets;
import org.apache.flink.runtime.state.KeyGroupsStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.junit.Assert;
import org.junit.Test;

public class KeyGroupsStateHandleTest {
    @Test
    public void testNonEmptyIntersection() {
        KeyGroupRangeOffsets offsets = new KeyGroupRangeOffsets(0, 7);
        byte[] dummy = new byte[10];
        ByteStreamStateHandle streamHandle = new ByteStreamStateHandle("test", dummy);
        KeyGroupsStateHandle handle = new KeyGroupsStateHandle(offsets, (StreamStateHandle)streamHandle);
        KeyGroupRange expectedRange = new KeyGroupRange(0, 3);
        KeyGroupsStateHandle newHandle = handle.getIntersection(expectedRange);
        Assert.assertNotNull((Object)newHandle);
        Assert.assertEquals((Object)streamHandle, (Object)newHandle.getDelegateStateHandle());
        Assert.assertEquals((Object)expectedRange, (Object)newHandle.getKeyGroupRange());
    }

    @Test
    public void testEmptyIntersection() {
        KeyGroupRangeOffsets offsets = new KeyGroupRangeOffsets(0, 7);
        byte[] dummy = new byte[10];
        ByteStreamStateHandle streamHandle = new ByteStreamStateHandle("test", dummy);
        KeyGroupsStateHandle handle = new KeyGroupsStateHandle(offsets, (StreamStateHandle)streamHandle);
        KeyGroupRange newRange = new KeyGroupRange(8, 11);
        Assert.assertNull((Object)handle.getIntersection(newRange));
    }
}

