/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.Optional;
import junit.framework.TestCase;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.junit.Assert;
import org.junit.Test;

public class SharedStateRegistryTest {
    @Test
    public void testRegistryNormal() {
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        TestSharedState firstState = new TestSharedState("first");
        SharedStateRegistry.Result result = sharedStateRegistry.registerReference(firstState.getRegistrationKey(), (StreamStateHandle)firstState);
        Assert.assertEquals((long)1L, (long)result.getReferenceCount());
        Assert.assertTrue((firstState == result.getReference() ? 1 : 0) != 0);
        TestCase.assertFalse((boolean)firstState.isDiscarded());
        TestSharedState secondState = new TestSharedState("second");
        result = sharedStateRegistry.registerReference(secondState.getRegistrationKey(), (StreamStateHandle)secondState);
        Assert.assertEquals((long)1L, (long)result.getReferenceCount());
        Assert.assertTrue((secondState == result.getReference() ? 1 : 0) != 0);
        TestCase.assertFalse((boolean)firstState.isDiscarded());
        TestCase.assertFalse((boolean)secondState.isDiscarded());
        TestSharedState firstStatePrime = new TestSharedState(firstState.getRegistrationKey().getKeyString());
        result = sharedStateRegistry.registerReference(firstState.getRegistrationKey(), (StreamStateHandle)firstStatePrime);
        Assert.assertEquals((long)2L, (long)result.getReferenceCount());
        TestCase.assertFalse((firstStatePrime == result.getReference() ? 1 : 0) != 0);
        Assert.assertTrue((firstState == result.getReference() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)firstStatePrime.isDiscarded());
        TestCase.assertFalse((boolean)firstState.isDiscarded());
        result = sharedStateRegistry.registerReference(firstState.getRegistrationKey(), (StreamStateHandle)firstState);
        Assert.assertEquals((long)3L, (long)result.getReferenceCount());
        Assert.assertTrue((firstState == result.getReference() ? 1 : 0) != 0);
        TestCase.assertFalse((boolean)firstState.isDiscarded());
        result = sharedStateRegistry.unregisterReference(secondState.getRegistrationKey());
        Assert.assertEquals((long)0L, (long)result.getReferenceCount());
        Assert.assertTrue((result.getReference() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)secondState.isDiscarded());
        result = sharedStateRegistry.unregisterReference(firstState.getRegistrationKey());
        Assert.assertEquals((long)2L, (long)result.getReferenceCount());
        Assert.assertTrue((firstState == result.getReference() ? 1 : 0) != 0);
        TestCase.assertFalse((boolean)firstState.isDiscarded());
    }

    @Test(expected=IllegalStateException.class)
    public void testUnregisterWithUnexistedKey() {
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        sharedStateRegistry.unregisterReference(new SharedStateRegistryKey("non-existent"));
    }

    private static class TestSharedState
    implements StreamStateHandle {
        private static final long serialVersionUID = 4468635881465159780L;
        private SharedStateRegistryKey key;
        private boolean discarded;

        TestSharedState(String key) {
            this.key = new SharedStateRegistryKey(key);
            this.discarded = false;
        }

        public SharedStateRegistryKey getRegistrationKey() {
            return this.key;
        }

        public void discardState() throws Exception {
            this.discarded = true;
        }

        public long getStateSize() {
            return this.key.toString().length();
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public FSDataInputStream openInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Optional<byte[]> asBytesIfInMemory() {
            return Optional.empty();
        }

        public boolean isDiscarded() {
            return this.discarded;
        }
    }
}

