/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;

public class TestingTaskExecutorService
implements TaskManagerRunner.TaskExecutorService {
    private final Runnable startRunnable;
    private final CompletableFuture<Void> terminationFuture;
    private final boolean completeTerminationFutureOnClose;

    private TestingTaskExecutorService(Runnable startRunnable, CompletableFuture<Void> terminationFuture, boolean completeTerminationFutureOnClose) {
        this.startRunnable = startRunnable;
        this.terminationFuture = terminationFuture;
        this.completeTerminationFutureOnClose = completeTerminationFutureOnClose;
    }

    public void start() {
        this.startRunnable.run();
    }

    public CompletableFuture<Void> getTerminationFuture() {
        return this.terminationFuture;
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.completeTerminationFutureOnClose) {
            this.terminationFuture.complete(null);
        }
        return this.terminationFuture;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Runnable startRunnable = () -> {};
        private CompletableFuture<Void> terminationFuture = new CompletableFuture();
        private boolean completeTerminationFutureOnClose = true;

        public Builder setStartRunnable(Runnable startRunnable) {
            this.startRunnable = startRunnable;
            return this;
        }

        public Builder setTerminationFuture(CompletableFuture<Void> terminationFuture) {
            this.terminationFuture = terminationFuture;
            return this;
        }

        public Builder withManualTerminationFutureCompletion() {
            this.completeTerminationFutureOnClose = false;
            return this;
        }

        TestingTaskExecutorService build() {
            return new TestingTaskExecutorService(this.startRunnable, this.terminationFuture, this.completeTerminationFutureOnClose);
        }
    }
}

