/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

public enum CheckpointType {
    CHECKPOINT(false, PostCheckpointAction.NONE),
    SAVEPOINT(true, PostCheckpointAction.NONE),
    SAVEPOINT_SUSPEND(true, PostCheckpointAction.SUSPEND),
    SAVEPOINT_TERMINATE(true, PostCheckpointAction.TERMINATE);

    private final boolean isSavepoint;
    private final PostCheckpointAction postCheckpointAction;

    private CheckpointType(boolean isSavepoint, PostCheckpointAction postCheckpointAction) {
        this.isSavepoint = isSavepoint;
        this.postCheckpointAction = postCheckpointAction;
    }

    public boolean isSavepoint() {
        return this.isSavepoint;
    }

    public boolean isSynchronous() {
        return this.postCheckpointAction != PostCheckpointAction.NONE;
    }

    public PostCheckpointAction getPostCheckpointAction() {
        return this.postCheckpointAction;
    }

    public boolean shouldAdvanceToEndOfTime() {
        return this.getPostCheckpointAction() == PostCheckpointAction.TERMINATE;
    }

    public boolean shouldIgnoreEndOfInput() {
        return this.getPostCheckpointAction() == PostCheckpointAction.SUSPEND;
    }

    public static enum PostCheckpointAction {
        NONE,
        SUSPEND,
        TERMINATE;

    }
}

