/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.writer.ChannelSelector;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.util.Preconditions;

public final class ChannelSelectorRecordWriter<T extends IOReadableWritable>
extends RecordWriter<T> {
    private final ChannelSelector<T> channelSelector;
    private final BufferBuilder[] bufferBuilders;

    ChannelSelectorRecordWriter(ResultPartitionWriter writer, ChannelSelector<T> channelSelector, long timeout, String taskName) {
        super(writer, timeout, taskName);
        this.channelSelector = (ChannelSelector)Preconditions.checkNotNull(channelSelector);
        this.channelSelector.setup(this.numberOfChannels);
        this.bufferBuilders = new BufferBuilder[this.numberOfChannels];
    }

    @Override
    public void emit(T record) throws IOException, InterruptedException {
        this.emit(record, this.channelSelector.selectChannel(record));
    }

    @Override
    public void randomEmit(T record) throws IOException, InterruptedException {
        this.emit(record, this.rng.nextInt(this.numberOfChannels));
    }

    @Override
    public void broadcastEmit(T record) throws IOException, InterruptedException {
        this.checkErroneous();
        this.serializer.serializeRecord(record);
        boolean pruneAfterCopying = false;
        for (int targetChannel = 0; targetChannel < this.numberOfChannels; ++targetChannel) {
            if (!this.copyFromSerializerToTargetChannel(targetChannel)) continue;
            pruneAfterCopying = true;
        }
        if (pruneAfterCopying) {
            this.serializer.prune();
        }
    }

    @Override
    public BufferBuilder getBufferBuilder(int targetChannel) throws IOException, InterruptedException {
        if (this.bufferBuilders[targetChannel] != null) {
            return this.bufferBuilders[targetChannel];
        }
        return this.requestNewBufferBuilder(targetChannel);
    }

    @Override
    public BufferBuilder requestNewBufferBuilder(int targetChannel) throws IOException, InterruptedException {
        Preconditions.checkState((this.bufferBuilders[targetChannel] == null || this.bufferBuilders[targetChannel].isFinished() ? 1 : 0) != 0);
        BufferBuilder bufferBuilder = super.requestNewBufferBuilder(targetChannel);
        this.addBufferConsumer(bufferBuilder.createBufferConsumer(), targetChannel);
        this.bufferBuilders[targetChannel] = bufferBuilder;
        return bufferBuilder;
    }

    @Override
    public void tryFinishCurrentBufferBuilder(int targetChannel) {
        if (this.bufferBuilders[targetChannel] == null) {
            return;
        }
        BufferBuilder bufferBuilder = this.bufferBuilders[targetChannel];
        this.bufferBuilders[targetChannel] = null;
        this.finishBufferBuilder(bufferBuilder);
    }

    @Override
    public void emptyCurrentBufferBuilder(int targetChannel) {
        this.bufferBuilders[targetChannel] = null;
    }

    @Override
    public void closeBufferBuilder(int targetChannel) {
        if (this.bufferBuilders[targetChannel] != null) {
            this.bufferBuilders[targetChannel].finish();
            this.bufferBuilders[targetChannel] = null;
        }
    }

    @Override
    public void clearBuffers() {
        for (int index = 0; index < this.numberOfChannels; ++index) {
            this.closeBufferBuilder(index);
        }
    }
}

