/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.scheduler.DeploymentOption;
import org.apache.flink.runtime.scheduler.ExecutionVertexDeploymentOption;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.runtime.topology.Vertex;
import org.apache.flink.util.IterableUtils;

class SchedulingStrategyUtils {
    SchedulingStrategyUtils() {
    }

    static Set<ExecutionVertexID> getAllVertexIdsFromTopology(SchedulingTopology topology) {
        return IterableUtils.toStream(topology.getVertices()).map(Vertex::getId).collect(Collectors.toSet());
    }

    static Set<SchedulingExecutionVertex> getVerticesFromIds(SchedulingTopology topology, Set<ExecutionVertexID> vertexIds) {
        return vertexIds.stream().map(topology::getVertex).collect(Collectors.toSet());
    }

    static List<ExecutionVertexDeploymentOption> createExecutionVertexDeploymentOptionsInTopologicalOrder(SchedulingTopology topology, Set<ExecutionVertexID> verticesToDeploy, Function<ExecutionVertexID, DeploymentOption> deploymentOptionRetriever) {
        return IterableUtils.toStream(topology.getVertices()).map(Vertex::getId).filter(verticesToDeploy::contains).map(executionVertexID -> new ExecutionVertexDeploymentOption((ExecutionVertexID)executionVertexID, (DeploymentOption)deploymentOptionRetriever.apply((ExecutionVertexID)executionVertexID))).collect(Collectors.toList());
    }

    static List<SchedulingPipelinedRegion> sortPipelinedRegionsInTopologicalOrder(SchedulingTopology topology, Set<SchedulingPipelinedRegion> regions) {
        return IterableUtils.toStream(topology.getVertices()).map(Vertex::getId).map(topology::getPipelinedRegionOfVertex).filter(regions::contains).distinct().collect(Collectors.toList());
    }
}

