/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointSubsumeHelper;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.util.Preconditions;

public class EmbeddedCompletedCheckpointStore
implements CompletedCheckpointStore {
    private final ArrayDeque<CompletedCheckpoint> checkpoints = new ArrayDeque(2);
    private final Collection<CompletedCheckpoint> suspended = new ArrayDeque<CompletedCheckpoint>(2);
    private final int maxRetainedCheckpoints;

    public EmbeddedCompletedCheckpointStore() {
        this(1);
    }

    EmbeddedCompletedCheckpointStore(int maxRetainedCheckpoints) {
        Preconditions.checkArgument((maxRetainedCheckpoints > 0 ? 1 : 0) != 0);
        this.maxRetainedCheckpoints = maxRetainedCheckpoints;
    }

    @Override
    public void recover() {
        this.checkpoints.addAll(this.suspended);
        this.suspended.clear();
    }

    @Override
    public void addCheckpoint(CompletedCheckpoint checkpoint, CheckpointsCleaner checkpointsCleaner, Runnable postCleanup) throws Exception {
        this.checkpoints.addLast(checkpoint);
        CheckpointSubsumeHelper.subsume(this.checkpoints, this.maxRetainedCheckpoints, CompletedCheckpoint::discardOnSubsume);
    }

    @VisibleForTesting
    void removeOldestCheckpoint() throws Exception {
        CompletedCheckpoint checkpointToSubsume = this.checkpoints.removeFirst();
        checkpointToSubsume.discardOnSubsume();
    }

    @Override
    public void shutdown(JobStatus jobStatus, CheckpointsCleaner checkpointsCleaner) throws Exception {
        if (jobStatus.isGloballyTerminalState()) {
            this.checkpoints.clear();
            this.suspended.clear();
        } else {
            this.suspended.clear();
            this.suspended.addAll(this.checkpoints);
            this.checkpoints.clear();
        }
    }

    @Override
    public List<CompletedCheckpoint> getAllCheckpoints() {
        return new ArrayList<CompletedCheckpoint>(this.checkpoints);
    }

    @Override
    public int getNumberOfRetainedCheckpoints() {
        return this.checkpoints.size();
    }

    @Override
    public int getMaxNumberOfRetainedCheckpoints() {
        return this.maxRetainedCheckpoints;
    }

    @Override
    public boolean requiresExternalizedCheckpoints() {
        return false;
    }
}

