/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;

public class ConsumedPartitionGroup
implements Iterable<IntermediateResultPartitionID> {
    private final List<IntermediateResultPartitionID> resultPartitions;

    private ConsumedPartitionGroup(List<IntermediateResultPartitionID> resultPartitions) {
        this.resultPartitions = resultPartitions;
    }

    public static ConsumedPartitionGroup fromMultiplePartitions(List<IntermediateResultPartitionID> resultPartitions) {
        return new ConsumedPartitionGroup(resultPartitions);
    }

    public static ConsumedPartitionGroup fromSinglePartition(IntermediateResultPartitionID resultPartition) {
        return new ConsumedPartitionGroup(Collections.singletonList(resultPartition));
    }

    @Override
    public Iterator<IntermediateResultPartitionID> iterator() {
        return this.resultPartitions.iterator();
    }

    public int size() {
        return this.resultPartitions.size();
    }

    public boolean isEmpty() {
        return this.resultPartitions.isEmpty();
    }

    public IntermediateResultPartitionID getFirst() {
        return this.iterator().next();
    }
}

