/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Properties;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.kafka.sink.KafkaRecordSerializationSchema;
import org.apache.flink.connector.kafka.sink.KafkaSink;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class KafkaSinkBuilder<IN> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaSinkBuilder.class);
    private static final Duration DEFAULT_KAFKA_TRANSACTION_TIMEOUT = Duration.ofHours(1L);
    private static final int MAXIMUM_PREFIX_BYTES = 64000;
    private DeliveryGuarantee deliveryGuarantee = DeliveryGuarantee.NONE;
    private String transactionalIdPrefix = "kafka-sink";
    private Properties kafkaProducerConfig;
    private KafkaRecordSerializationSchema<IN> recordSerializer;
    private String bootstrapServers;

    KafkaSinkBuilder() {
    }

    public KafkaSinkBuilder<IN> setDeliverGuarantee(DeliveryGuarantee deliveryGuarantee) {
        this.deliveryGuarantee = (DeliveryGuarantee)((Object)Preconditions.checkNotNull((Object)((Object)deliveryGuarantee), (String)"deliveryGuarantee"));
        return this;
    }

    public KafkaSinkBuilder<IN> setKafkaProducerConfig(Properties kafkaProducerConfig) {
        this.kafkaProducerConfig = (Properties)Preconditions.checkNotNull((Object)kafkaProducerConfig, (String)"kafkaProducerConfig");
        if (!kafkaProducerConfig.containsKey("key.serializer")) {
            kafkaProducerConfig.put("key.serializer", ByteArraySerializer.class.getName());
        } else {
            LOG.warn("Overwriting the '{}' is not recommended", (Object)"key.serializer");
        }
        if (!kafkaProducerConfig.containsKey("value.serializer")) {
            kafkaProducerConfig.put("value.serializer", ByteArraySerializer.class.getName());
        } else {
            LOG.warn("Overwriting the '{}' is not recommended", (Object)"value.serializer");
        }
        if (!kafkaProducerConfig.containsKey("transaction.timeout.ms")) {
            long timeout = DEFAULT_KAFKA_TRANSACTION_TIMEOUT.toMillis();
            Preconditions.checkState((timeout < Integer.MAX_VALUE && timeout > 0L ? 1 : 0) != 0, (Object)"timeout does not fit into 32 bit integer");
            kafkaProducerConfig.put("transaction.timeout.ms", (Object)((int)timeout));
            LOG.warn("Property [{}] not specified. Setting it to {}", (Object)"transaction.timeout.ms", (Object)DEFAULT_KAFKA_TRANSACTION_TIMEOUT);
        }
        return this;
    }

    public KafkaSinkBuilder<IN> setRecordSerializer(KafkaRecordSerializationSchema<IN> recordSerializer) {
        this.recordSerializer = (KafkaRecordSerializationSchema)Preconditions.checkNotNull(recordSerializer, (String)"recordSerializer");
        ClosureCleaner.clean(this.recordSerializer, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        return this;
    }

    public KafkaSinkBuilder<IN> setTransactionalIdPrefix(String transactionalIdPrefix) {
        this.transactionalIdPrefix = (String)Preconditions.checkNotNull((Object)transactionalIdPrefix, (String)"transactionalIdPrefix");
        Preconditions.checkState((transactionalIdPrefix.getBytes(StandardCharsets.UTF_8).length <= 64000 ? 1 : 0) != 0, (Object)"The configured prefix is too long and the resulting transactionalId might exceed Kafka's transactionalIds size.");
        return this;
    }

    public KafkaSinkBuilder<IN> setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = (String)Preconditions.checkNotNull((Object)bootstrapServers);
        return this;
    }

    public KafkaSink<IN> build() {
        if (this.kafkaProducerConfig == null) {
            this.setKafkaProducerConfig(new Properties());
        }
        Preconditions.checkNotNull((Object)this.bootstrapServers);
        if (this.deliveryGuarantee == DeliveryGuarantee.EXACTLY_ONCE) {
            Preconditions.checkState((this.transactionalIdPrefix != null ? 1 : 0) != 0, (Object)"EXACTLY_ONCE delivery guarantee requires a transactionIdPrefix to be set to provide unique transaction names across multiple KafkaSinks writing to the same Kafka cluster.");
        }
        this.kafkaProducerConfig.put("bootstrap.servers", this.bootstrapServers);
        return new KafkaSink(this.deliveryGuarantee, this.kafkaProducerConfig, this.transactionalIdPrefix, (KafkaRecordSerializationSchema)Preconditions.checkNotNull(this.recordSerializer, (String)"recordSerializer"));
    }
}

