/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.split;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class KafkaPartitionSplit
implements SourceSplit {
    public static final long NO_STOPPING_OFFSET = Long.MIN_VALUE;
    public static final long LATEST_OFFSET = -1L;
    public static final long EARLIEST_OFFSET = -2L;
    public static final long COMMITTED_OFFSET = -3L;
    public static final Set<Long> VALID_STARTING_OFFSET_MARKERS = new HashSet<Long>(Arrays.asList(-2L, -1L, -3L));
    public static final Set<Long> VALID_STOPPING_OFFSET_MARKERS = new HashSet<Long>(Arrays.asList(-1L, -3L, Long.MIN_VALUE));
    private final TopicPartition tp;
    private final long startingOffset;
    private final long stoppingOffset;

    public KafkaPartitionSplit(TopicPartition tp, long startingOffset) {
        this(tp, startingOffset, Long.MIN_VALUE);
    }

    public KafkaPartitionSplit(TopicPartition tp, long startingOffset, long stoppingOffset) {
        KafkaPartitionSplit.verifyInitialOffset(tp, startingOffset, stoppingOffset);
        this.tp = tp;
        this.startingOffset = startingOffset;
        this.stoppingOffset = stoppingOffset;
    }

    public String getTopic() {
        return this.tp.topic();
    }

    public int getPartition() {
        return this.tp.partition();
    }

    public TopicPartition getTopicPartition() {
        return this.tp;
    }

    public long getStartingOffset() {
        return this.startingOffset;
    }

    public Optional<Long> getStoppingOffset() {
        return this.stoppingOffset > 0L || this.stoppingOffset == -1L || this.stoppingOffset == -3L ? Optional.of(this.stoppingOffset) : Optional.empty();
    }

    public String splitId() {
        return KafkaPartitionSplit.toSplitId(this.tp);
    }

    public String toString() {
        return String.format("[Partition: %s, StartingOffset: %d, StoppingOffset: %d]", this.tp, this.startingOffset, this.stoppingOffset);
    }

    public int hashCode() {
        return Objects.hash(this.tp, this.startingOffset, this.stoppingOffset);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KafkaPartitionSplit)) {
            return false;
        }
        KafkaPartitionSplit other = (KafkaPartitionSplit)obj;
        return this.tp.equals(other.tp) && this.startingOffset == other.startingOffset && this.stoppingOffset == other.stoppingOffset;
    }

    public static String toSplitId(TopicPartition tp) {
        return tp.toString();
    }

    private static void verifyInitialOffset(TopicPartition tp, Long startingOffset, long stoppingOffset) {
        if (startingOffset == null) {
            throw new FlinkRuntimeException("Cannot initialize starting offset for partition " + tp);
        }
        if (startingOffset < 0L && !VALID_STARTING_OFFSET_MARKERS.contains(startingOffset)) {
            throw new FlinkRuntimeException(String.format("Invalid starting offset %d is specified for partition %s. It should either be non-negative or be one of the [%d(earliest), %d(latest), %d(committed)].", startingOffset, tp, -1L, -2L, -3L));
        }
        if (stoppingOffset < 0L && !VALID_STOPPING_OFFSET_MARKERS.contains(stoppingOffset)) {
            throw new FlinkRuntimeException(String.format("Illegal stopping offset %d is specified for partition %s. It should either be non-negative or be one of the [%d(latest), %d(committed), %d(Long.MIN_VALUE, no_stopping_offset)].", stoppingOffset, tp, -1L, -3L, Long.MIN_VALUE));
        }
    }
}

