/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.internals;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.AbstractOptions;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Node;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;

public final class ConsumerGroupOperationContext<T, O extends AbstractOptions<O>> {
    private final String groupId;
    private final O options;
    private final long deadline;
    private final KafkaFutureImpl<T> future;
    private Optional<Node> node;

    public ConsumerGroupOperationContext(String groupId, O options, long deadline, KafkaFutureImpl<T> future) {
        this.groupId = groupId;
        this.options = options;
        this.deadline = deadline;
        this.future = future;
        this.node = Optional.empty();
    }

    public String groupId() {
        return this.groupId;
    }

    public O options() {
        return this.options;
    }

    public long deadline() {
        return this.deadline;
    }

    public KafkaFutureImpl<T> future() {
        return this.future;
    }

    public Optional<Node> node() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = Optional.ofNullable(node);
    }

    public static boolean hasCoordinatorMoved(AbstractResponse response) {
        return ConsumerGroupOperationContext.hasCoordinatorMoved(response.errorCounts());
    }

    public static boolean hasCoordinatorMoved(Map<Errors, Integer> errorCounts) {
        return errorCounts.containsKey((Object)Errors.NOT_COORDINATOR);
    }

    public static boolean shouldRefreshCoordinator(Map<Errors, Integer> errorCounts) {
        return errorCounts.containsKey((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS) || errorCounts.containsKey((Object)Errors.COORDINATOR_NOT_AVAILABLE);
    }
}

