/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ByteUtils;

public class FetchSnapshotRequestData
implements ApiMessage {
    String clusterId;
    int replicaId;
    int maxBytes;
    List<TopicSnapshot> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower"), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch from all of the snapshots"), new Field("topics", new CompactArrayOf(TopicSnapshot.SCHEMA_0), "The topics to fetch"), Field.TaggedFieldsSection.of(0, new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The clusterId if known, this is used to validate metadata fetches prior to broker registration")));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public FetchSnapshotRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public FetchSnapshotRequestData() {
        this.clusterId = null;
        this.replicaId = -1;
        this.maxBytes = Integer.MAX_VALUE;
        this.topics = new ArrayList<TopicSnapshot>(0);
    }

    @Override
    public short apiKey() {
        return 59;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.clusterId = null;
        this.replicaId = _readable.readInt();
        this.maxBytes = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        ArrayList<TopicSnapshot> newCollection = new ArrayList<TopicSnapshot>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TopicSnapshot(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block4: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 0: {
                    int length = _readable.readUnsignedVarint() - 1;
                    if (length < 0) {
                        this.clusterId = null;
                        continue block4;
                    }
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field clusterId had invalid length " + length);
                    }
                    this.clusterId = _readable.readString(length);
                    continue block4;
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (this.clusterId != null) {
            ++_numTaggedFields;
        }
        _writable.writeInt(this.replicaId);
        _writable.writeInt(this.maxBytes);
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        for (TopicSnapshot topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (this.clusterId != null) {
            _writable.writeUnsignedVarint(0);
            byte[] _stringBytes = _cache.getSerializedValue(this.clusterId);
            _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (this.clusterId != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            byte[] _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clusterId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clusterId, _stringBytes);
            int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + _stringBytes.length));
        }
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (TopicSnapshot topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FetchSnapshotRequestData)) {
            return false;
        }
        FetchSnapshotRequestData other = (FetchSnapshotRequestData)obj;
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.replicaId != other.replicaId) {
            return false;
        }
        if (this.maxBytes != other.maxBytes) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        hashCode = 31 * hashCode + this.replicaId;
        hashCode = 31 * hashCode + this.maxBytes;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public FetchSnapshotRequestData duplicate() {
        FetchSnapshotRequestData _duplicate = new FetchSnapshotRequestData();
        _duplicate.clusterId = this.clusterId == null ? null : this.clusterId;
        _duplicate.replicaId = this.replicaId;
        _duplicate.maxBytes = this.maxBytes;
        ArrayList<TopicSnapshot> newTopics = new ArrayList<TopicSnapshot>(this.topics.size());
        for (TopicSnapshot _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "FetchSnapshotRequestData(clusterId=" + (this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", replicaId=" + this.replicaId + ", maxBytes=" + this.maxBytes + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int replicaId() {
        return this.replicaId;
    }

    public int maxBytes() {
        return this.maxBytes;
    }

    public List<TopicSnapshot> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public FetchSnapshotRequestData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public FetchSnapshotRequestData setReplicaId(int v) {
        this.replicaId = v;
        return this;
    }

    public FetchSnapshotRequestData setMaxBytes(int v) {
        this.maxBytes = v;
        return this;
    }

    public FetchSnapshotRequestData setTopics(List<TopicSnapshot> v) {
        this.topics = v;
        return this;
    }

    public static class SnapshotId
    implements Message {
        long endOffset;
        int epoch;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("end_offset", Type.INT64, ""), new Field("epoch", Type.INT32, ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public SnapshotId(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public SnapshotId() {
            this.endOffset = 0L;
            this.epoch = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of SnapshotId");
            }
            this.endOffset = _readable.readLong();
            this.epoch = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeLong(this.endOffset);
            _writable.writeInt(this.epoch);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of SnapshotId");
            }
            _size.addBytes(8);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SnapshotId)) {
                return false;
            }
            SnapshotId other = (SnapshotId)obj;
            if (this.endOffset != other.endOffset) {
                return false;
            }
            if (this.epoch != other.epoch) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.endOffset >> 32) ^ (int)this.endOffset);
            hashCode = 31 * hashCode + this.epoch;
            return hashCode;
        }

        @Override
        public SnapshotId duplicate() {
            SnapshotId _duplicate = new SnapshotId();
            _duplicate.endOffset = this.endOffset;
            _duplicate.epoch = this.epoch;
            return _duplicate;
        }

        public String toString() {
            return "SnapshotId(endOffset=" + this.endOffset + ", epoch=" + this.epoch + ")";
        }

        public long endOffset() {
            return this.endOffset;
        }

        public int epoch() {
            return this.epoch;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public SnapshotId setEndOffset(long v) {
            this.endOffset = v;
            return this;
        }

        public SnapshotId setEpoch(int v) {
            this.epoch = v;
            return this;
        }
    }

    public static class PartitionSnapshot
    implements Message {
        int partition;
        int currentLeaderEpoch;
        SnapshotId snapshotId;
        long position;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition", Type.INT32, "The partition index"), new Field("current_leader_epoch", Type.INT32, "The current leader epoch of the partition, -1 for unknown leader epoch"), new Field("snapshot_id", SnapshotId.SCHEMA_0, "The snapshot endOffset and epoch to fetch"), new Field("position", Type.INT64, "The byte position within the snapshot to start fetching from"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public PartitionSnapshot(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionSnapshot() {
            this.partition = 0;
            this.currentLeaderEpoch = 0;
            this.snapshotId = new SnapshotId();
            this.position = 0L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionSnapshot");
            }
            this.partition = _readable.readInt();
            this.currentLeaderEpoch = _readable.readInt();
            this.snapshotId = new SnapshotId(_readable, _version);
            this.position = _readable.readLong();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partition);
            _writable.writeInt(this.currentLeaderEpoch);
            this.snapshotId.write(_writable, _cache, _version);
            _writable.writeLong(this.position);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionSnapshot");
            }
            _size.addBytes(4);
            _size.addBytes(4);
            int _sizeBeforeStruct = _size.totalSize();
            this.snapshotId.addSize(_size, _cache, _version);
            int n = _size.totalSize() - _sizeBeforeStruct;
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionSnapshot)) {
                return false;
            }
            PartitionSnapshot other = (PartitionSnapshot)obj;
            if (this.partition != other.partition) {
                return false;
            }
            if (this.currentLeaderEpoch != other.currentLeaderEpoch) {
                return false;
            }
            if (this.snapshotId == null ? other.snapshotId != null : !this.snapshotId.equals(other.snapshotId)) {
                return false;
            }
            if (this.position != other.position) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partition;
            hashCode = 31 * hashCode + this.currentLeaderEpoch;
            hashCode = 31 * hashCode + (this.snapshotId == null ? 0 : this.snapshotId.hashCode());
            hashCode = 31 * hashCode + ((int)(this.position >> 32) ^ (int)this.position);
            return hashCode;
        }

        @Override
        public PartitionSnapshot duplicate() {
            PartitionSnapshot _duplicate = new PartitionSnapshot();
            _duplicate.partition = this.partition;
            _duplicate.currentLeaderEpoch = this.currentLeaderEpoch;
            _duplicate.snapshotId = this.snapshotId.duplicate();
            _duplicate.position = this.position;
            return _duplicate;
        }

        public String toString() {
            return "PartitionSnapshot(partition=" + this.partition + ", currentLeaderEpoch=" + this.currentLeaderEpoch + ", snapshotId=" + this.snapshotId.toString() + ", position=" + this.position + ")";
        }

        public int partition() {
            return this.partition;
        }

        public int currentLeaderEpoch() {
            return this.currentLeaderEpoch;
        }

        public SnapshotId snapshotId() {
            return this.snapshotId;
        }

        public long position() {
            return this.position;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionSnapshot setPartition(int v) {
            this.partition = v;
            return this;
        }

        public PartitionSnapshot setCurrentLeaderEpoch(int v) {
            this.currentLeaderEpoch = v;
            return this;
        }

        public PartitionSnapshot setSnapshotId(SnapshotId v) {
            this.snapshotId = v;
            return this;
        }

        public PartitionSnapshot setPosition(long v) {
            this.position = v;
            return this;
        }
    }

    public static class TopicSnapshot
    implements Message {
        String name;
        List<PartitionSnapshot> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.COMPACT_STRING, "The name of the topic to fetch"), new Field("partitions", new CompactArrayOf(PartitionSnapshot.SCHEMA_0), "The partitions to fetch"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicSnapshot(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicSnapshot() {
            this.name = "";
            this.partitions = new ArrayList<PartitionSnapshot>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicSnapshot");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            ArrayList<PartitionSnapshot> newCollection = new ArrayList<PartitionSnapshot>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionSnapshot(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                PartitionSnapshot partitionsElement = (PartitionSnapshot)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicSnapshot");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (PartitionSnapshot partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicSnapshot)) {
                return false;
            }
            TopicSnapshot other = (TopicSnapshot)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TopicSnapshot duplicate() {
            TopicSnapshot _duplicate = new TopicSnapshot();
            _duplicate.name = this.name;
            ArrayList<PartitionSnapshot> newPartitions = new ArrayList<PartitionSnapshot>(this.partitions.size());
            for (PartitionSnapshot _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicSnapshot(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<PartitionSnapshot> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicSnapshot setName(String v) {
            this.name = v;
            return this;
        }

        public TopicSnapshot setPartitions(List<PartitionSnapshot> v) {
            this.partitions = v;
            return this;
        }
    }
}

