/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.network;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Configurable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.config.AbstractConfig;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.config.SslClientAuth;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.network.Authenticator;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.network.ChannelBuilder;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.network.ListenerName;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.network.Mode;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.network.PlaintextChannelBuilder;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.network.SaslChannelBuilder;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.network.SslChannelBuilder;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.network.TransportLayer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.JaasContext;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.auth.DefaultPrincipalBuilder;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.auth.PrincipalBuilder;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.LogContext;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Time;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelBuilders {
    private static final Logger log = LoggerFactory.getLogger(ChannelBuilders.class);

    private ChannelBuilders() {
    }

    public static ChannelBuilder clientChannelBuilder(SecurityProtocol securityProtocol, JaasContext.Type contextType, AbstractConfig config, ListenerName listenerName, String clientSaslMechanism, Time time, boolean saslHandshakeRequestEnable, LogContext logContext) {
        if (securityProtocol == SecurityProtocol.SASL_PLAINTEXT || securityProtocol == SecurityProtocol.SASL_SSL) {
            if (contextType == null) {
                throw new IllegalArgumentException("`contextType` must be non-null if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
            }
            if (clientSaslMechanism == null) {
                throw new IllegalArgumentException("`clientSaslMechanism` must be non-null in client mode if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
            }
        }
        return ChannelBuilders.create(securityProtocol, Mode.CLIENT, contextType, config, listenerName, false, clientSaslMechanism, saslHandshakeRequestEnable, null, null, time, logContext, null);
    }

    public static ChannelBuilder serverChannelBuilder(ListenerName listenerName, boolean isInterBrokerListener, SecurityProtocol securityProtocol, AbstractConfig config, CredentialCache credentialCache, DelegationTokenCache tokenCache, Time time, LogContext logContext, Supplier<ApiVersionsResponse> apiVersionSupplier) {
        return ChannelBuilders.create(securityProtocol, Mode.SERVER, JaasContext.Type.SERVER, config, listenerName, isInterBrokerListener, null, true, credentialCache, tokenCache, time, logContext, apiVersionSupplier);
    }

    private static ChannelBuilder create(SecurityProtocol securityProtocol, Mode mode, JaasContext.Type contextType, AbstractConfig config, ListenerName listenerName, boolean isInterBrokerListener, String clientSaslMechanism, boolean saslHandshakeRequestEnable, CredentialCache credentialCache, DelegationTokenCache tokenCache, Time time, LogContext logContext, Supplier<ApiVersionsResponse> apiVersionSupplier) {
        ChannelBuilder channelBuilder;
        Map<String, Object> configs = ChannelBuilders.channelBuilderConfigs(config, listenerName);
        switch (securityProtocol) {
            case SSL: {
                ChannelBuilders.requireNonNullMode(mode, securityProtocol);
                channelBuilder = new SslChannelBuilder(mode, listenerName, isInterBrokerListener, logContext);
                break;
            }
            case SASL_SSL: 
            case SASL_PLAINTEXT: {
                HashMap<String, JaasContext> jaasContexts;
                ChannelBuilders.requireNonNullMode(mode, securityProtocol);
                String sslClientAuthOverride = null;
                if (mode == Mode.SERVER) {
                    List enabledMechanisms = (List)configs.get("sasl.enabled.mechanisms");
                    jaasContexts = new HashMap(enabledMechanisms.size());
                    for (String mechanism : enabledMechanisms) {
                        jaasContexts.put(mechanism, JaasContext.loadServerContext(listenerName, mechanism, configs));
                    }
                    if (listenerName != null && securityProtocol == SecurityProtocol.SASL_SSL) {
                        String configuredClientAuth = (String)configs.get("ssl.client.auth");
                        String listenerClientAuth = (String)config.originalsWithPrefix(listenerName.configPrefix(), true).get("ssl.client.auth");
                        if (listenerClientAuth == null) {
                            sslClientAuthOverride = SslClientAuth.NONE.name().toLowerCase(Locale.ROOT);
                            if (configuredClientAuth != null && !configuredClientAuth.equalsIgnoreCase(SslClientAuth.NONE.name())) {
                                log.warn("Broker configuration '{}' is applied only to SSL listeners. Listener-prefixed configuration can be used to enable SSL client authentication for SASL_SSL listeners. In future releases, broker-wide option without listener prefix may be applied to SASL_SSL listeners as well. All configuration options intended for specific listeners should be listener-prefixed.", (Object)"ssl.client.auth");
                            }
                        }
                    }
                } else {
                    JaasContext jaasContext = contextType == JaasContext.Type.CLIENT ? JaasContext.loadClientContext(configs) : JaasContext.loadServerContext(listenerName, clientSaslMechanism, configs);
                    jaasContexts = Collections.singletonMap(clientSaslMechanism, jaasContext);
                }
                channelBuilder = new SaslChannelBuilder(mode, jaasContexts, securityProtocol, listenerName, isInterBrokerListener, clientSaslMechanism, saslHandshakeRequestEnable, credentialCache, tokenCache, sslClientAuthOverride, time, logContext, apiVersionSupplier);
                break;
            }
            case PLAINTEXT: {
                channelBuilder = new PlaintextChannelBuilder(listenerName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected securityProtocol " + (Object)((Object)securityProtocol));
            }
        }
        channelBuilder.configure(configs);
        return channelBuilder;
    }

    static Map<String, Object> channelBuilderConfigs(AbstractConfig config, ListenerName listenerName) {
        Map<String, Object> parsedConfigs = listenerName == null ? config.values() : config.valuesWithPrefixOverride(listenerName.configPrefix());
        config.originals().entrySet().stream().filter(e -> !parsedConfigs.containsKey(e.getKey())).filter(e -> listenerName == null || !((String)e.getKey()).startsWith(listenerName.configPrefix()) || !parsedConfigs.containsKey(((String)e.getKey()).substring(listenerName.configPrefix().length()))).filter(e -> listenerName == null || !parsedConfigs.containsKey(((String)e.getKey()).substring(((String)e.getKey()).indexOf(46) + 1))).forEach(e -> parsedConfigs.put((String)e.getKey(), e.getValue()));
        return parsedConfigs;
    }

    private static void requireNonNullMode(Mode mode, SecurityProtocol securityProtocol) {
        if (mode == null) {
            throw new IllegalArgumentException("`mode` must be non-null if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
        }
    }

    private static PrincipalBuilder createPrincipalBuilder(Class<?> principalBuilderClass, Map<String, ?> configs) {
        PrincipalBuilder principalBuilder = principalBuilderClass == null ? new DefaultPrincipalBuilder() : (PrincipalBuilder)Utils.newInstance(principalBuilderClass);
        principalBuilder.configure(configs);
        return principalBuilder;
    }

    public static KafkaPrincipalBuilder createPrincipalBuilder(Map<String, ?> configs, TransportLayer transportLayer, Authenticator authenticator, KerberosShortNamer kerberosShortNamer, SslPrincipalMapper sslPrincipalMapper) {
        KafkaPrincipalBuilder builder;
        Class principalBuilderClass = (Class)configs.get("principal.builder.class");
        if (principalBuilderClass == null || principalBuilderClass == DefaultKafkaPrincipalBuilder.class) {
            builder = new DefaultKafkaPrincipalBuilder(kerberosShortNamer, sslPrincipalMapper);
        } else if (KafkaPrincipalBuilder.class.isAssignableFrom(principalBuilderClass)) {
            builder = (KafkaPrincipalBuilder)Utils.newInstance(principalBuilderClass);
        } else if (PrincipalBuilder.class.isAssignableFrom(principalBuilderClass)) {
            PrincipalBuilder oldPrincipalBuilder = ChannelBuilders.createPrincipalBuilder(principalBuilderClass, configs);
            builder = DefaultKafkaPrincipalBuilder.fromOldPrincipalBuilder(authenticator, transportLayer, oldPrincipalBuilder, kerberosShortNamer);
        } else {
            throw new InvalidConfigurationException("Type " + principalBuilderClass.getName() + " is not an instance of " + PrincipalBuilder.class.getName() + " or " + KafkaPrincipalBuilder.class.getName());
        }
        if (builder instanceof Configurable) {
            ((Configurable)((Object)builder)).configure(configs);
        }
        return builder;
    }
}

